"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContextVariableList = exports.getContextScopeValues = void 0;
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _std = require("@kbn/std");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _i18n2 = require("./i18n");
var _util = require("./util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Part of context scope extracted from an api
 * Expose on the scope as: `{{context.panel.id}}`, `{{context.panel.filters.[0]}}`
 */

const getContextScopeValues = context => {
  var _api$dataViews$, _api$dataViews$2, _api$savedObjectId$, _api$parentApi, _api$parentApi$query$, _api$timeRange$$value, _api$timeRange$, _api$parentApi2, _api$parentApi2$timeR, _api$parentApi3, _api$parentApi3$filte;
  if (!context.embeddable) throw new Error("UrlDrilldown [getContextScope] can't build scope because embeddable object is missing in context");
  const api = context.embeddable;
  const dataViewIds = (_api$dataViews$ = api.dataViews$) !== null && _api$dataViews$ !== void 0 && _api$dataViews$.value ? (_api$dataViews$2 = api.dataViews$) === null || _api$dataViews$2 === void 0 ? void 0 : _api$dataViews$2.value.map(dataView => dataView.id).filter(Boolean) : [];
  return {
    panel: (0, _util.deleteUndefinedKeys)({
      id: api.uuid,
      title: (0, _presentationPublishing.getTitle)(api),
      savedObjectId: (_api$savedObjectId$ = api.savedObjectId$) === null || _api$savedObjectId$ === void 0 ? void 0 : _api$savedObjectId$.value,
      query: (_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : (_api$parentApi$query$ = _api$parentApi.query$) === null || _api$parentApi$query$ === void 0 ? void 0 : _api$parentApi$query$.value,
      timeRange: (_api$timeRange$$value = (_api$timeRange$ = api.timeRange$) === null || _api$timeRange$ === void 0 ? void 0 : _api$timeRange$.value) !== null && _api$timeRange$$value !== void 0 ? _api$timeRange$$value : (_api$parentApi2 = api.parentApi) === null || _api$parentApi2 === void 0 ? void 0 : (_api$parentApi2$timeR = _api$parentApi2.timeRange$) === null || _api$parentApi2$timeR === void 0 ? void 0 : _api$parentApi2$timeR.value,
      filters: (_api$parentApi3 = api.parentApi) === null || _api$parentApi3 === void 0 ? void 0 : (_api$parentApi3$filte = _api$parentApi3.filters$) === null || _api$parentApi3$filte === void 0 ? void 0 : _api$parentApi3$filte.value,
      indexPatternIds: dataViewIds.length > 1 ? dataViewIds : undefined,
      indexPatternId: dataViewIds.length === 1 ? dataViewIds[0] : undefined
    })
  };
};
exports.getContextScopeValues = getContextScopeValues;
const variableDescriptions = {
  id: {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.id.title', {
      defaultMessage: 'Panel ID.'
    }),
    documentation: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.id.documentation', {
      defaultMessage: 'ID of the panel where drilldown is executed.'
    })
  },
  title: {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.title.title', {
      defaultMessage: 'Panel title.'
    }),
    documentation: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.title.documentation', {
      defaultMessage: 'Title of the panel where drilldown is executed.'
    })
  },
  filters: {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.filters.title', {
      defaultMessage: 'Panel filters.'
    }),
    documentation: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.filters.documentation', {
      defaultMessage: 'List of Kibana filters applied to a panel.'
    })
  },
  'query.query': {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.query.query.title', {
      defaultMessage: 'Query string.'
    })
  },
  'query.language': {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.query.language.title', {
      defaultMessage: 'Query language.'
    })
  },
  'timeRange.from': {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.timeRange.from.title', {
      defaultMessage: 'Time picker "from" value.'
    })
  },
  'timeRange.to': {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.timeRange.to.title', {
      defaultMessage: 'Time picker "to" value.'
    })
  },
  indexPatternId: {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.timeRange.indexPatternId.title', {
      defaultMessage: 'Index pattern ID.'
    }),
    documentation: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.timeRange.indexPatternId.documentation', {
      defaultMessage: 'First index pattern ID used by the panel.'
    })
  },
  indexPatternIds: {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.timeRange.indexPatternIds.title', {
      defaultMessage: 'Index pattern IDs.'
    }),
    documentation: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.timeRange.indexPatternIds.documentation', {
      defaultMessage: 'List of all index pattern IDs used by the panel.'
    })
  },
  savedObjectId: {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.savedObjectId.title', {
      defaultMessage: 'Saved object ID.'
    }),
    documentation: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.savedObjectId.documentation', {
      defaultMessage: 'ID of the saved object behind the panel.'
    })
  }
};
const kind = _monaco.monaco.languages.CompletionItemKind.Variable;
const sortPrefix = '2.';
const formatValue = value => {
  if (typeof value === 'object') {
    return '\n' + JSON.stringify(value, null, 4);
  }
  return String(value);
};
const getPanelVariableList = values => {
  const variables = [];
  const flattenedValues = (0, _std.getFlattenedObject)(values);
  const keys = Object.keys(flattenedValues).sort();
  for (const key of keys) {
    const description = variableDescriptions[key];
    const label = 'context.panel.' + key;
    if (!description) {
      variables.push({
        label,
        sortText: sortPrefix + label,
        documentation: !!flattenedValues[key] ? (0, _i18n2.txtValue)(formatValue(flattenedValues[key])) : '',
        kind
      });
      continue;
    }
    variables.push({
      label,
      sortText: sortPrefix + label,
      title: description.title,
      documentation: (description.documentation || '') + (!!description.documentation && !!flattenedValues[key] ? '\n\n' : '') + (!!flattenedValues[key] ? (0, _i18n2.txtValue)(formatValue(flattenedValues[key])) : ''),
      kind
    });
  }
  return variables;
};
const getContextVariableList = context => {
  const values = getContextScopeValues(context);
  const variables = getPanelVariableList(values.panel);
  return variables;
};
exports.getContextVariableList = getContextVariableList;