"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uptimeRuleTypeFieldMap = exports.updateState = exports.setRecoveredAlertsContext = exports.getViewInAppUrl = exports.getAlertDetailsUrl = exports.generateAlertMessage = exports.UptimeRuleTypeAlertDefinition = void 0;
var _Either = require("fp-ts/Either");
var _mustache = _interopRequireDefault(require("mustache"));
var _common = require("@kbn/observability-plugin/common");
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _common2 = require("@kbn/spaces-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _uptime_rule_field_map = require("../../../../common/rules/uptime_rule_field_map");
var _synthetics_alerts = require("../../../../common/constants/synthetics_alerts");
var _runtime_types = require("../../../../common/runtime_types");
var _action_variables = require("./action_variables");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateState = (state, isTriggeredNow) => {
  const now = new Date().toISOString();
  const decoded = _runtime_types.UptimeCommonStateType.decode(state);
  if (!(0, _Either.isRight)(decoded)) {
    const triggerVal = isTriggeredNow ? now : undefined;
    return {
      currentTriggerStarted: triggerVal,
      firstCheckedAt: now,
      firstTriggeredAt: triggerVal,
      isTriggered: isTriggeredNow,
      lastTriggeredAt: triggerVal,
      lastCheckedAt: now,
      lastResolvedAt: undefined
    };
  }
  const {
    currentTriggerStarted,
    firstCheckedAt,
    firstTriggeredAt,
    lastTriggeredAt,
    // this is the stale trigger status, we're naming it `wasTriggered`
    // to differentiate it from the `isTriggeredNow` param
    isTriggered: wasTriggered,
    lastResolvedAt
  } = decoded.right;
  let cts;
  if (isTriggeredNow && !currentTriggerStarted) {
    cts = now;
  } else if (isTriggeredNow) {
    cts = currentTriggerStarted;
  }
  return {
    currentTriggerStarted: cts,
    firstCheckedAt: firstCheckedAt !== null && firstCheckedAt !== void 0 ? firstCheckedAt : now,
    firstTriggeredAt: isTriggeredNow && !firstTriggeredAt ? now : firstTriggeredAt,
    lastCheckedAt: now,
    lastTriggeredAt: isTriggeredNow ? now : lastTriggeredAt,
    lastResolvedAt: !isTriggeredNow && wasTriggered ? now : lastResolvedAt,
    isTriggered: isTriggeredNow
  };
};
exports.updateState = updateState;
const generateAlertMessage = (messageTemplate, fields) => {
  return _mustache.default.render(messageTemplate, {
    context: {
      ...fields
    },
    state: {
      ...fields
    }
  });
};
exports.generateAlertMessage = generateAlertMessage;
const getViewInAppUrl = (basePath, spaceId, relativeViewInAppUrl) => (0, _common2.addSpaceIdToPath)(basePath.publicBaseUrl, spaceId, relativeViewInAppUrl);
exports.getViewInAppUrl = getViewInAppUrl;
const getAlertDetailsUrl = (basePath, spaceId, alertUuid) => (0, _common2.addSpaceIdToPath)(basePath.publicBaseUrl, spaceId, `/app/observability/alerts/${alertUuid}`);
exports.getAlertDetailsUrl = getAlertDetailsUrl;
const setRecoveredAlertsContext = async ({
  alertsClient,
  alertsLocator,
  basePath,
  defaultStartedAt,
  spaceId
}) => {
  for (const recoveredAlert of (_alertsClient$getReco = alertsClient === null || alertsClient === void 0 ? void 0 : alertsClient.getRecoveredAlerts()) !== null && _alertsClient$getReco !== void 0 ? _alertsClient$getReco : []) {
    var _alertsClient$getReco, _recoveredAlert$alert;
    const recoveredAlertId = recoveredAlert.alert.getId();
    const alertUuid = recoveredAlert.alert.getUuid();
    const indexedStartedAt = (_recoveredAlert$alert = recoveredAlert.alert.getStart()) !== null && _recoveredAlert$alert !== void 0 ? _recoveredAlert$alert : defaultStartedAt;
    const state = recoveredAlert.alert.getState();
    const alertUrl = await (0, _common.getAlertUrl)(alertUuid, spaceId, indexedStartedAt, alertsLocator, basePath.publicBaseUrl);
    alertsClient.setAlertData({
      id: recoveredAlertId,
      context: {
        ...state,
        [_action_variables.ALERT_DETAILS_URL]: alertUrl
      }
    });
  }
};
exports.setRecoveredAlertsContext = setRecoveredAlertsContext;
const uptimeRuleTypeFieldMap = exports.uptimeRuleTypeFieldMap = {
  ..._uptime_rule_field_map.uptimeRuleFieldMap,
  ..._alertsAsDataUtils.legacyExperimentalFieldMap
};
const stringAsKeywords = {
  path_match: `${_ruleDataUtils.ALERT_GROUPING}.*`,
  match_mapping_type: 'string',
  mapping: {
    type: 'keyword',
    ignore_above: 1024
  }
};
const dynamicTemplates = [{
  strings_as_keywords: stringAsKeywords
}];
const UptimeRuleTypeAlertDefinition = exports.UptimeRuleTypeAlertDefinition = {
  context: _synthetics_alerts.SYNTHETICS_RULE_TYPES_ALERT_CONTEXT,
  mappings: {
    fieldMap: uptimeRuleTypeFieldMap,
    dynamicTemplates
  },
  useLegacyAlerts: true,
  shouldWrite: true
};