"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-shared-plugin/public");
var _hooks = require("../hooks");
var _monitor = require("../components/monitor");
var _dynamic_settings = require("../state/actions/dynamic_settings");
var _actions = require("../state/actions");
var _alerts = require("../state/alerts/alerts");
var _use_init_app = require("../hooks/use_init_app");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/pages/monitor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorPage = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _use_init_app.useInitApp)();
  (0, _react.useEffect)(() => {
    dispatch((0, _dynamic_settings.getDynamicSettings)());
  }, [dispatch]);
  const monitorId = (0, _hooks.useMonitorId)();
  (0, _react.useEffect)(() => {
    dispatch((0, _actions.setSelectedMonitorId)(monitorId));
    dispatch(_alerts.getMonitorAlertsAction.get());
  }, [monitorId, dispatch]);
  (0, _public.useTrackPageview)({
    app: 'uptime',
    path: 'monitor'
  });
  (0, _public.useTrackPageview)({
    app: 'uptime',
    path: 'monitor',
    delay: 15000
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_monitor.MonitorStatusDetails, {
    monitorId: monitorId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_monitor.MonitorCharts, {
    monitorId: monitorId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_monitor.PingList, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
};
exports.MonitorPage = MonitorPage;