"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInfraKubernetesHref = exports.getInfraIpHref = exports.getInfraContainerHref = void 0;
var _add_base_path = require("./add_base_path");
var _build_href = require("./build_href");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInfraContainerHref = ({
  state
}, locator) => {
  var _pings$, _pings$$container;
  if (!locator) {
    return undefined;
  }
  const pings = Array.isArray(state.summaryPings) ? state.summaryPings : [state.summaryPings];

  // Pick the first container id if one is available
  const containerId = (_pings$ = pings[0]) === null || _pings$ === void 0 ? void 0 : (_pings$$container = _pings$.container) === null || _pings$$container === void 0 ? void 0 : _pings$$container.id;
  return containerId ? locator.getRedirectUrl({
    entityType: 'container',
    entityId: containerId
  }) : undefined;
};
exports.getInfraContainerHref = getInfraContainerHref;
const getInfraKubernetesHref = ({
  state
}, locator) => {
  var _pings$2, _pings$2$kubernetes, _pings$2$kubernetes$p;
  if (!locator) {
    return undefined;
  }
  const pings = Array.isArray(state.summaryPings) ? state.summaryPings : [state.summaryPings];

  // Pick the first pod id if one is available
  const podId = (_pings$2 = pings[0]) === null || _pings$2 === void 0 ? void 0 : (_pings$2$kubernetes = _pings$2.kubernetes) === null || _pings$2$kubernetes === void 0 ? void 0 : (_pings$2$kubernetes$p = _pings$2$kubernetes.pod) === null || _pings$2$kubernetes$p === void 0 ? void 0 : _pings$2$kubernetes$p.uid;
  return podId ? locator.getRedirectUrl({
    entityType: 'pod',
    entityId: podId
  }) : undefined;
};
exports.getInfraKubernetesHref = getInfraKubernetesHref;
const getInfraIpHref = (summary, basePath) => {
  const getHref = value => {
    if (!value) {
      return undefined;
    }
    if (!Array.isArray(value)) {
      const expression = encodeURIComponent(`host.ip : ${value}`);
      return (0, _add_base_path.addBasePath)(basePath, `/app/metrics/inventory?waffleFilter=(expression:'${expression}',kind:kuery)`);
    }
    const ips = value.reduce((str, cur) => !str ? `host.ip : ${cur}` : str + ` or host.ip : ${cur}`, '');
    return ips === '' ? undefined : (0, _add_base_path.addBasePath)(basePath, `/app/metrics/inventory?waffleFilter=(expression:'${encodeURIComponent(ips)}',kind:kuery)`);
  };
  return (0, _build_href.buildHref)(summary.state.summaryPings || [], ping => {
    var _ping$monitor;
    return ping === null || ping === void 0 ? void 0 : (_ping$monitor = ping.monitor) === null || _ping$monitor === void 0 ? void 0 : _ping$monitor.ip;
  }, getHref);
};
exports.getInfraIpHref = getInfraIpHref;