"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.microToMilli = microToMilli;
exports.microToSec = microToSec;
exports.milliToSec = milliToSec;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// one second = 1 million micros
const ONE_SECOND_AS_MICROS = 1000000;
const ONE_SECOND_AS_MILLI = 1000;
const ONE_MILLI_AS_MICRO = 1000;
function milliToSec(ms) {
  return ms / ONE_SECOND_AS_MILLI;
}
function microToSec(micro, fixedNumber) {
  if (fixedNumber) {
    return (micro / ONE_SECOND_AS_MICROS).toFixed(fixedNumber);
  }
  return (micro / ONE_SECOND_AS_MICROS).toFixed(0);
}
function microToMilli(micro) {
  return (micro / ONE_MILLI_AS_MICRO).toFixed(0);
}