"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initTlsAlertType = void 0;
var _react = _interopRequireDefault(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _uptime_alerts = require("../../../../common/constants/uptime_alerts");
var _translations = require("../../../../common/rules/legacy_uptime/translations");
var _ui = require("../../../../common/constants/ui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/lib/alert_types/tls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let validateFunc;
const {
  defaultActionMessage,
  defaultRecoveryMessage,
  description
} = _translations.TlsTranslations;
const TLSAlert = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./lazy_wrapper/tls_alert'))));
const initTlsAlertType = ({
  core,
  plugins,
  isHidden
}) => ({
  id: _uptime_alerts.CLIENT_ALERT_TYPES.TLS,
  iconClass: 'uptimeApp',
  documentationUrl(docLinks) {
    return `${docLinks.links.observability.tlsCertificate}`;
  },
  ruleParamsExpression: params => /*#__PURE__*/_react.default.createElement(TLSAlert, {
    core: core,
    plugins: plugins,
    id: params.id,
    ruleParams: params.ruleParams,
    setRuleParams: params.setRuleParams,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }),
  description,
  validate: ruleParams => {
    if (!validateFunc) {
      (async function loadValidate() {
        const {
          validateTLSAlertParams
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./lazy_wrapper/validate_tls_alert')));
        validateFunc = validateTLSAlertParams;
      })();
    }
    return validateFunc ? validateFunc(ruleParams) : {};
  },
  defaultActionMessage,
  defaultRecoveryMessage,
  requiresAppContext: isHidden,
  format: ({
    fields
  }) => ({
    reason: fields[_ruleDataUtils.ALERT_REASON] || '',
    link: `/app/uptime${_ui.CERTIFICATES_ROUTE}`
  })
});
exports.initTlsAlertType = initTlsAlertType;