"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateTLSAlertParams = validateTLSAlertParams;
var _PathReporter = require("io-ts/lib/PathReporter");
var _Either = require("fp-ts/Either");
var _tls = require("../../../../../common/runtime_types/alerts/tls");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateTLSAlertParams(ruleParams) {
  const errors = {};
  const decoded = _tls.TLSParamsType.decode(ruleParams);
  if (!(0, _Either.isRight)(decoded)) {
    return {
      errors: {
        typeCheckFailure: 'Provided parameters do not conform to the expected type.',
        typeCheckParsingMessage: _PathReporter.PathReporter.report(decoded)
      }
    };
  }
  return {
    errors
  };
}