"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldCompose = shouldCompose;
exports.useCompositeImage = void 0;
var _reactRedux = require("react-redux");
var _react = _interopRequireDefault(require("react"));
var _compose_screenshot_images = require("../lib/helper/compose_screenshot_images");
var _runtime_types = require("../../../common/runtime_types");
var _synthetics = require("../state/reducers/synthetics");
var _selectors = require("../state/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function allBlocksLoaded(blocks, hashes) {
  for (const hash of hashes) {
    if (!blocks[hash] || (0, _runtime_types.isPendingBlock)(blocks[hash])) {
      return false;
    }
  }
  return true;
}

/**
 * Checks if two refs are the same. If the ref is unchanged, there's no need
 * to run the expensive draw procedure.
 *
 * The key fields here are `step.index` and `check_group`, as there's a 1:1 between
 * journey and check group, and each step has a unique index within a journey.
 */
const isNewRef = ({
  ref: {
    screenshotRef: {
      synthetics: {
        step: {
          index: indexA
        }
      },
      monitor: {
        check_group: checkGroupA
      }
    }
  }
}, {
  ref: {
    screenshotRef: {
      synthetics: {
        step: {
          index: indexB
        }
      },
      monitor: {
        check_group: checkGroupB
      }
    }
  }
}) => indexA !== indexB || checkGroupA !== checkGroupB;
function shouldCompose(imageData, imgRef, curRef, blocks) {
  return allBlocksLoaded(blocks, imgRef.ref.screenshotRef.screenshot_ref.blocks.map(({
    hash
  }) => hash)) && (typeof imageData === 'undefined' || isNewRef(imgRef, curRef));
}

/**
 * Assembles the data for a composite image and returns the composite to a callback.
 * @param imgRef the data and dimensions for the composite image.
 * @param onComposeImageSuccess sends the composited image to this callback.
 * @param imageData this is the composited image value, if it is truthy the function will skip the compositing process
 */
const useCompositeImage = (imgRef, onComposeImageSuccess, imageData) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    blocks
  } = (0, _reactRedux.useSelector)(_selectors.syntheticsSelector);
  _react.default.useEffect(() => {
    dispatch((0, _synthetics.fetchBlocksAction)(imgRef.ref.screenshotRef.screenshot_ref.blocks.map(({
      hash
    }) => hash)));
  }, [dispatch, imgRef.ref.screenshotRef.screenshot_ref.blocks]);
  const [curRef, setCurRef] = _react.default.useState(imgRef);
  _react.default.useEffect(() => {
    const canvas = document.createElement('canvas');
    async function compose() {
      await (0, _compose_screenshot_images.composeScreenshotRef)(imgRef, canvas, blocks);
      const imgData = canvas.toDataURL('image/jpg', 1.0);
      onComposeImageSuccess(imgData);
    }

    // if the URL is truthy it means it's already been composed, so there
    // is no need to call the function
    if (shouldCompose(imageData, imgRef, curRef, blocks)) {
      compose();
      setCurRef(imgRef);
    }
    return () => {
      var _canvas$parentElement;
      (_canvas$parentElement = canvas.parentElement) === null || _canvas$parentElement === void 0 ? void 0 : _canvas$parentElement.removeChild(canvas);
    };
  }, [blocks, curRef, imageData, imgRef, onComposeImageSuccess]);
};
exports.useCompositeImage = useCompositeImage;