"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUptimeSettingsContext = exports.UptimeSettingsContextProvider = exports.UptimeSettingsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../common/constants");
var _hooks = require("../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/contexts/uptime_settings_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  BASE_PATH
} = _constants.CONTEXT_DEFAULTS;
const {
  DATE_RANGE_START,
  DATE_RANGE_END
} = _constants.CLIENT_DEFAULTS;

/**
 * These are default values for the context. These defaults are typically
 * overwritten by the Uptime App upon its invocation.
 */
const defaultContext = {
  basePath: BASE_PATH,
  dateRangeStart: DATE_RANGE_START,
  dateRangeEnd: DATE_RANGE_END,
  isApmAvailable: true,
  isInfraAvailable: true,
  isLogsAvailable: true,
  isDev: false
};
const UptimeSettingsContext = exports.UptimeSettingsContext = /*#__PURE__*/(0, _react.createContext)(defaultContext);
const UptimeSettingsContextProvider = ({
  children,
  ...props
}) => {
  const {
    basePath,
    isApmAvailable,
    isInfraAvailable,
    isLogsAvailable,
    commonlyUsedRanges,
    isDev
  } = props;
  const {
    dateRangeStart,
    dateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  const value = (0, _react.useMemo)(() => {
    return {
      isDev,
      basePath,
      isApmAvailable,
      isInfraAvailable,
      isLogsAvailable,
      commonlyUsedRanges,
      dateRangeStart: dateRangeStart !== null && dateRangeStart !== void 0 ? dateRangeStart : DATE_RANGE_START,
      dateRangeEnd: dateRangeEnd !== null && dateRangeEnd !== void 0 ? dateRangeEnd : DATE_RANGE_END
    };
  }, [isDev, basePath, isApmAvailable, isInfraAvailable, isLogsAvailable, dateRangeStart, dateRangeEnd, commonlyUsedRanges]);
  return /*#__PURE__*/_react.default.createElement(UptimeSettingsContext.Provider, {
    value: value,
    children: children,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 10
    }
  });
};
exports.UptimeSettingsContextProvider = UptimeSettingsContextProvider;
const useUptimeSettingsContext = () => (0, _react.useContext)(UptimeSettingsContext);
exports.useUptimeSettingsContext = useUptimeSettingsContext;