"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusBadge = void 0;
exports.colorFromStatus = colorFromStatus;
exports.textFromStatus = textFromStatus;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/synthetics/status_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function colorFromStatus(color, status) {
  switch (status) {
    case 'succeeded':
      return color.success;
    case 'failed':
      return color.danger;
    default:
      return 'default';
  }
}
function textFromStatus(status) {
  switch (status) {
    case 'succeeded':
      return _i18n.i18n.translate('xpack.uptime.synthetics.statusBadge.succeededMessage', {
        defaultMessage: 'Succeeded'
      });
    case 'failed':
      return _i18n.i18n.translate('xpack.uptime.synthetics.statusBadge.failedMessage', {
        defaultMessage: 'Failed'
      });
    case 'skipped':
      return _i18n.i18n.translate('xpack.uptime.synthetics.statusBadge.skippedMessage', {
        defaultMessage: 'Skipped'
      });
    default:
      return null;
  }
}
const StatusBadge = ({
  status,
  stepNo,
  isMobile
}) => {
  const theme = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, !isMobile && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textNoWrap",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, stepNo, "."))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: colorFromStatus({
      danger: theme.euiTheme.colors.danger,
      success: theme.euiTheme.colors.success
    }, status),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, textFromStatus(status))));
};
exports.StatusBadge = StatusBadge;