"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutedStep = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _code_block_accordion = require("./code_block_accordion");
var _step_screenshots = require("./check_steps/step_expanded_row/step_screenshots");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/synthetics/executed_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CODE_BLOCK_OVERFLOW_HEIGHT = 360;
const Label = _common.euiStyled.div`
  margin-bottom: ${props => props.theme.eui.euiSizeXS};
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeS};
  color: ${({
  theme
}) => theme.eui.euiColorDarkShade};
`;
const Message = _common.euiStyled.div`
  font-weight: bold;
  font-size:${({
  theme
}) => theme.eui.euiFontSizeM};
  margin-bottom: ${props => props.theme.eui.euiSizeM};
`;
const ExpandedRow = _common.euiStyled.div`
  padding: '8px';
  max-width: 1000px;
  width: 100%;
`;
const ExecutedStep = ({
  loading,
  step,
  index,
  browserConsoles
}) => {
  var _step$synthetics, _step$synthetics$payl, _step$synthetics2, _step$synthetics2$err, _step$synthetics3, _step$synthetics3$err, _step$synthetics4, _step$synthetics4$ste, _step$synthetics5, _step$synthetics5$pay, _step$synthetics6, _step$synthetics6$ste, _step$synthetics7, _step$synthetics7$ste, _step$synthetics8, _step$synthetics8$err;
  const isSucceeded = ((_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : (_step$synthetics$payl = _step$synthetics.payload) === null || _step$synthetics$payl === void 0 ? void 0 : _step$synthetics$payl.status) === 'succeeded';
  return /*#__PURE__*/_react.default.createElement(ExpandedRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }), ((_step$synthetics2 = step.synthetics) === null || _step$synthetics2 === void 0 ? void 0 : (_step$synthetics2$err = _step$synthetics2.error) === null || _step$synthetics2$err === void 0 ? void 0 : _step$synthetics2$err.message) && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(Label, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.uptime.synthetics.executedStep.errorHeading', {
    defaultMessage: 'Error message'
  })), /*#__PURE__*/_react.default.createElement(Message, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 15
    }
  }, (_step$synthetics3 = step.synthetics) === null || _step$synthetics3 === void 0 ? void 0 : (_step$synthetics3$err = _step$synthetics3.error) === null || _step$synthetics3$err === void 0 ? void 0 : _step$synthetics3$err.message)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_code_block_accordion.CodeBlockAccordion, {
    id: ((_step$synthetics4 = step.synthetics) === null || _step$synthetics4 === void 0 ? void 0 : (_step$synthetics4$ste = _step$synthetics4.step) === null || _step$synthetics4$ste === void 0 ? void 0 : _step$synthetics4$ste.name) + String(index),
    buttonContent: _i18n.i18n.translate('xpack.uptime.synthetics.executedStep.scriptHeading.label', {
      defaultMessage: 'Script executed at this step'
    }),
    overflowHeight: CODE_BLOCK_OVERFLOW_HEIGHT,
    language: "javascript",
    initialIsOpen: !isSucceeded,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, (_step$synthetics5 = step.synthetics) === null || _step$synthetics5 === void 0 ? void 0 : (_step$synthetics5$pay = _step$synthetics5.payload) === null || _step$synthetics5$pay === void 0 ? void 0 : _step$synthetics5$pay.source), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_code_block_accordion.CodeBlockAccordion, {
    id: ((_step$synthetics6 = step.synthetics) === null || _step$synthetics6 === void 0 ? void 0 : (_step$synthetics6$ste = _step$synthetics6.step) === null || _step$synthetics6$ste === void 0 ? void 0 : _step$synthetics6$ste.name) + String(index),
    buttonContent: _i18n.i18n.translate('xpack.uptime.synthetics.executedStep.consoleOutput.label', {
      defaultMessage: 'Console output'
    }),
    overflowHeight: CODE_BLOCK_OVERFLOW_HEIGHT,
    language: "javascript",
    initialIsOpen: !isSucceeded,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, browserConsoles === null || browserConsoles === void 0 ? void 0 : browserConsoles.join('\n')), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_step_screenshots.StepScreenshots, {
    step: step,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_code_block_accordion.CodeBlockAccordion, {
    id: `${(_step$synthetics7 = step.synthetics) === null || _step$synthetics7 === void 0 ? void 0 : (_step$synthetics7$ste = _step$synthetics7.step) === null || _step$synthetics7$ste === void 0 ? void 0 : _step$synthetics7$ste.name}_stack`,
    buttonContent: _i18n.i18n.translate('xpack.uptime.synthetics.executedStep.stackTrace', {
      defaultMessage: 'Stack trace'
    }),
    language: "html",
    overflowHeight: CODE_BLOCK_OVERFLOW_HEIGHT,
    initialIsOpen: !isSucceeded,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }, (_step$synthetics8 = step.synthetics) === null || _step$synthetics8 === void 0 ? void 0 : (_step$synthetics8$err = _step$synthetics8.error) === null || _step$synthetics8$err === void 0 ? void 0 : _step$synthetics8$err.stack)));
};
exports.ExecutedStep = ExecutedStep;