"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleOutputEventList = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _console_event = require("./console_event");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/synthetics/console_output_event_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CONSOLE_STEP_TYPES = ['stderr', 'stdout', 'cmd/status'];
const isConsoleStep = step => CONSOLE_STEP_TYPES.some(type => type === step.synthetics.type);
const ConsoleOutputEventList = ({
  journey
}) => /*#__PURE__*/_react.default.createElement("div", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 26,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 27,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("h4", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 28,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.uptime.synthetics.consoleStepList.title",
  defaultMessage: "No steps ran",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 9
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 35,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.uptime.synthetics.consoleStepList.message",
  defaultMessage: "This journey failed to run, recorded console output is shown below:",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 37,
    columnNumber: 7
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 5
  }
}, journey.steps.filter(isConsoleStep).map(consoleEvent => /*#__PURE__*/_react.default.createElement(_console_event.ConsoleEvent, {
  event: consoleEvent,
  key: consoleEvent._id + '_console-event-row',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 9
  }
}))));
exports.ConsoleOutputEventList = ConsoleOutputEventList;