"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCheckSteps = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _journey = require("../../../state/actions/journey");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCheckSteps = () => {
  var _checkGroup$steps, _checkGroup$loading;
  const {
    checkGroupId
  } = (0, _reactRouterDom.useParams)();
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch((0, _journey.getJourneySteps)({
      checkGroup: checkGroupId
    }));
  }, [checkGroupId, dispatch]);
  const checkGroup = (0, _reactRedux.useSelector)(state => {
    return state.journeys[checkGroupId];
  });
  return {
    checkGroup: checkGroupId,
    steps: (_checkGroup$steps = checkGroup === null || checkGroup === void 0 ? void 0 : checkGroup.steps) !== null && _checkGroup$steps !== void 0 ? _checkGroup$steps : [],
    details: checkGroup === null || checkGroup === void 0 ? void 0 : checkGroup.details,
    loading: (_checkGroup$loading = checkGroup === null || checkGroup === void 0 ? void 0 : checkGroup.loading) !== null && _checkGroup$loading !== void 0 ? _checkGroup$loading : false,
    error: checkGroup === null || checkGroup === void 0 ? void 0 : checkGroup.error
  };
};
exports.useCheckSteps = useCheckSteps;