"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSettingsErrors = void 0;
var _lodash = require("lodash");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _translations = require("../../pages/translations");
var _settings = require("../../pages/settings");
var _default_email = require("./default_email");
var _selectors = require("../../state/selectors");
var _alerts = require("../../state/alerts/alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasInvalidEmail = (defaultConnectors, value) => {
  if (!defaultConnectors || defaultConnectors.length === 0) {
    return;
  }
  if (!value || !value.to) {
    return {
      to: REQUIRED_EMAIL
    };
  }
  const toError = value.to.length === 0 ? REQUIRED_EMAIL : getInvalidEmailError(value.to);
  const ccError = getInvalidEmailError(value.cc);
  const bccError = getInvalidEmailError(value.bcc);
  if (toError || ccError || bccError) {
    return {
      to: toError,
      cc: ccError,
      bcc: bccError
    };
  }
};
const isEmailChanged = (prev, next) => {
  var _prev$to, _next$to, _prev$cc, _next$cc, _prev$bcc, _next$bcc;
  if (!(0, _lodash.isEqual)(((_prev$to = prev === null || prev === void 0 ? void 0 : prev.to) !== null && _prev$to !== void 0 ? _prev$to : []).sort(), ((_next$to = next === null || next === void 0 ? void 0 : next.to) !== null && _next$to !== void 0 ? _next$to : []).sort())) {
    return true;
  }
  if (!(0, _lodash.isEqual)(((_prev$cc = prev === null || prev === void 0 ? void 0 : prev.cc) !== null && _prev$cc !== void 0 ? _prev$cc : []).sort(), ((_next$cc = next === null || next === void 0 ? void 0 : next.cc) !== null && _next$cc !== void 0 ? _next$cc : []).sort())) {
    return true;
  }
  if (!(0, _lodash.isEqual)(((_prev$bcc = prev === null || prev === void 0 ? void 0 : prev.bcc) !== null && _prev$bcc !== void 0 ? _prev$bcc : []).sort(), ((_next$bcc = next === null || next === void 0 ? void 0 : next.bcc) !== null && _next$bcc !== void 0 ? _next$bcc : []).sort())) {
    return true;
  }
};
const isDirtyForm = (formFields, settings) => {
  return (settings === null || settings === void 0 ? void 0 : settings.certAgeThreshold) !== (formFields === null || formFields === void 0 ? void 0 : formFields.certAgeThreshold) || (settings === null || settings === void 0 ? void 0 : settings.certExpirationThreshold) !== (formFields === null || formFields === void 0 ? void 0 : formFields.certExpirationThreshold) || (settings === null || settings === void 0 ? void 0 : settings.heartbeatIndices) !== (formFields === null || formFields === void 0 ? void 0 : formFields.heartbeatIndices) || isEmailChanged(settings === null || settings === void 0 ? void 0 : settings.defaultEmail, formFields === null || formFields === void 0 ? void 0 : formFields.defaultEmail) || JSON.stringify(settings === null || settings === void 0 ? void 0 : settings.defaultConnectors) !== JSON.stringify(formFields === null || formFields === void 0 ? void 0 : formFields.defaultConnectors);
};
const useSettingsErrors = formFields => {
  const dss = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  const isFormDirty = isDirtyForm(formFields, dss.settings);
  const {
    data = []
  } = (0, _reactRedux.useSelector)(_alerts.connectorsSelector);
  const hasEmailConnector = data === null || data === void 0 ? void 0 : data.find(connector => {
    var _formFields$defaultCo;
    return (formFields === null || formFields === void 0 ? void 0 : (_formFields$defaultCo = formFields.defaultConnectors) === null || _formFields$defaultCo === void 0 ? void 0 : _formFields$defaultCo.includes(connector.id)) && connector.actionTypeId === '.email';
  });
  if (formFields) {
    const {
      certAgeThreshold,
      certExpirationThreshold,
      heartbeatIndices
    } = formFields;
    const indErrorSpace = heartbeatIndices !== null && heartbeatIndices !== void 0 && heartbeatIndices.includes(' ') ? _translations.SPACE_STR : '';
    const indError = indErrorSpace || (heartbeatIndices !== null && heartbeatIndices !== void 0 && heartbeatIndices.match(/^\S+$/) ? '' : _translations.BLANK_STR);
    const ageError = (0, _settings.isValidCertVal)(certAgeThreshold);
    const expError = (0, _settings.isValidCertVal)(certExpirationThreshold);
    return {
      isFormDirty,
      errors: {
        heartbeatIndices: indError,
        expirationThresholdError: expError,
        ageThresholdError: ageError,
        invalidEmail: hasEmailConnector ? hasInvalidEmail(formFields.defaultConnectors, formFields.defaultEmail) : undefined
      }
    };
  }
  return {
    isFormDirty,
    errors: null
  };
};
exports.useSettingsErrors = useSettingsErrors;
const REQUIRED_EMAIL = _i18n.i18n.translate('xpack.uptime.sourceConfiguration.alertDefaultForm.requiredEmail', {
  defaultMessage: 'To email is required for email connector'
});
const getInvalidEmailError = value => {
  if (!value) {
    return;
  }
  const inValidEmail = value.find(val => !(0, _default_email.validateEmail)(val));
  if (!inValidEmail) {
    return;
  }
  return _i18n.i18n.translate('xpack.uptime.sourceConfiguration.alertDefaultForm.invalidEmail', {
    defaultMessage: '{val} is not a valid email.',
    values: {
      val: inValidEmail
    }
  });
};