"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorListComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _monitor_status_column = require("./columns/monitor_status_column");
var _charts = require("../../common/charts");
var _overview_page_link = require("./overview_page_link");
var _translations = _interopRequireWildcard(require("./translations"));
var labels = _translations;
var _monitor_list_page_size_select = require("./monitor_list_page_size_select");
var _list_drawer_container = require("./monitor_list_drawer/list_drawer_container");
var _cert_status_column = require("./columns/cert_status_column");
var _monitor_list_header = require("./monitor_list_header");
var _translations2 = require("../../../../../common/translations/translations");
var _enable_alert = require("./columns/enable_alert");
var _monitor_name_col = require("./columns/monitor_name_col");
var _monitor_tags = require("../../common/monitor_tags");
var _use_monitor_histogram = require("./use_monitor_histogram");
var _no_items_message = require("./no_items_message");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/monitor_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorListComponent = ({
  filters,
  monitorList: {
    list,
    error,
    loading
  },
  pageSize,
  setPageSize,
  isPending
}) => {
  var _list$summaries, _list$nextPagePaginat, _list$prevPagePaginat, _error$body;
  const [expandedDrawerIds, updateExpandedDrawerIds] = (0, _react.useState)([]);
  const currentBreakpoint = (0, _eui.useCurrentEuiBreakpoint)();
  const [hideExtraColumns, setHideExtraColumns] = (0, _react.useState)(false);
  (0, _useDebounce.default)(() => {
    if (currentBreakpoint) {
      setHideExtraColumns(['m', 'l'].includes(currentBreakpoint));
    }
  }, 50, [currentBreakpoint]);
  const items = (_list$summaries = list.summaries) !== null && _list$summaries !== void 0 ? _list$summaries : [];
  const {
    histogramsById,
    minInterval
  } = (0, _use_monitor_histogram.useMonitorHistogram)({
    items
  });
  const nextPagePagination = (_list$nextPagePaginat = list.nextPagePagination) !== null && _list$nextPagePaginat !== void 0 ? _list$nextPagePaginat : '';
  const prevPagePagination = (_list$prevPagePaginat = list.prevPagePagination) !== null && _list$prevPagePaginat !== void 0 ? _list$prevPagePaginat : '';
  const toggleDrawer = id => {
    if (expandedDrawerIds.includes(id)) {
      updateExpandedDrawerIds(expandedDrawerIds.filter(p => p !== id));
    } else {
      updateExpandedDrawerIds([...expandedDrawerIds, id]);
    }
  };
  const getExpandedRowMap = () => {
    return expandedDrawerIds.reduce((map, id) => {
      return {
        ...map,
        [id]: /*#__PURE__*/_react.default.createElement(_list_drawer_container.MonitorListDrawer, {
          summary: items.find(({
            monitor_id: monitorId
          }) => monitorId === id),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 95,
            columnNumber: 11
          }
        })
      };
    }, {});
  };
  const columns = [...[{
    align: 'left',
    field: 'state.summary.status',
    name: labels.STATUS_COLUMN_LABEL,
    mobileOptions: {
      fullWidth: true
    },
    render: (status, {
      state: {
        timestamp,
        summaryPings,
        error: summaryError
      }
    }) => {
      return /*#__PURE__*/_react.default.createElement(_monitor_status_column.MonitorListStatusColumn, {
        status: status,
        timestamp: timestamp,
        summaryPings: summaryPings !== null && summaryPings !== void 0 ? summaryPings : [],
        summaryError: summaryError,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 13
        }
      });
    }
  }, {
    align: 'left',
    field: 'state.monitor.name',
    name: labels.NAME_COLUMN_LABEL,
    mobileOptions: {
      fullWidth: true
    },
    render: (_name, summary) => /*#__PURE__*/_react.default.createElement(_monitor_name_col.MonitorNameColumn, {
      summary: summary,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 61
      }
    }),
    sortable: true
  }, {
    align: 'left',
    field: 'state.url.full',
    name: _translations2.URL_LABEL,
    width: '30%',
    render: url => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsColumnsLink",
      href: url,
      target: "_blank",
      color: "text",
      external: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 11
      }
    }, url)
  }, {
    align: 'left',
    field: 'state.monitor.name',
    name: _translations2.TAGS_LABEL,
    width: '12%',
    render: (_name, summary) => /*#__PURE__*/_react.default.createElement(_monitor_tags.MonitorTags, {
      summary: summary,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 61
      }
    })
  }, {
    align: 'left',
    field: 'state.tls.server.x509',
    name: labels.TLS_COLUMN_LABEL,
    render: x509 => /*#__PURE__*/_react.default.createElement(_cert_status_column.CertStatusColumn, {
      expiry: x509,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 39
      }
    })
  }], ...(!hideExtraColumns ? [{
    align: 'left',
    field: 'monitor_id',
    name: labels.HISTORY_COLUMN_LABEL,
    mobileOptions: {
      show: false
    },
    render: monitorId => {
      var _histogramsById$monit;
      return /*#__PURE__*/_react.default.createElement(_charts.MonitorBarSeries, {
        histogramSeries: histogramsById === null || histogramsById === void 0 ? void 0 : (_histogramsById$monit = histogramsById[monitorId]) === null || _histogramsById$monit === void 0 ? void 0 : _histogramsById$monit.points,
        minInterval: minInterval,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 177,
          columnNumber: 15
        }
      });
    }
  }] : []), {
    align: 'center',
    field: '',
    name: _translations.STATUS_ALERT_COLUMN,
    width: '100px',
    render: item => /*#__PURE__*/_react.default.createElement(_enable_alert.EnableMonitorAlert, {
      monitorId: item.monitor_id,
      selectedMonitor: item.state.summaryPings[0],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 9
      }
    })
  }, ...(!hideExtraColumns ? [{
    align: 'right',
    field: 'monitor_id',
    name: '',
    sortable: true,
    isExpander: true,
    width: '40px',
    render: id => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": labels.getExpandDrawerLabel(id),
        "data-test-subj": `xpack.synthetics.monitorList.${id}.expandMonitorDetail`,
        iconType: expandedDrawerIds.includes(id) ? 'arrowUp' : 'arrowDown',
        onClick: () => toggleDrawer(id),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 17
        }
      });
    }
  }] : [])];
  return /*#__PURE__*/_react.default.createElement(WrapperPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_list_header.MonitorListHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "aria-label": labels.getDescriptionLabel(items.length),
    error: (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || (error === null || error === void 0 ? void 0 : error.message),
    loading: loading || isPending,
    itemId: "monitor_id",
    itemIdToExpandedRowMap: getExpandedRowMap(),
    items: items,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_no_items_message.NoItemsMessage, {
      loading: Boolean(loading || isPending),
      filters: filters,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 11
      }
    }),
    columns: columns,
    tableLayout: "auto",
    rowProps: hideExtraColumns ? ({
      monitor_id: monitorId
    }) => ({
      onClick: () => toggleDrawer(monitorId),
      'aria-label': labels.getExpandDrawerLabel(monitorId)
    }) : ({
      monitor_id: monitorId
    }) => ({
      className: undefined
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_list_page_size_select.MonitorListPageSizeSelect, {
    size: pageSize,
    setSize: setPageSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_page_link.OverviewPageLink, {
    dataTestSubj: "xpack.uptime.monitorList.prevButton",
    direction: "prev",
    pagination: prevPagePagination,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_page_link.OverviewPageLink, {
    dataTestSubj: "xpack.uptime.monitorList.nextButton",
    direction: "next",
    pagination: nextPagePagination,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 15
    }
  }))))));
};
exports.MonitorListComponent = MonitorListComponent;
const WrapperPanel = (0, _common.euiStyled)(_eui.EuiPanel)`
  &&&  {
  .refresh-row{
    background-color: #f0f4fb;
    -webkit-transition: background-color 3000ms linear;
    -ms-transition: background-color 3000ms linear;
    transition: background-color 3000ms linear;
    }
  }
`;