"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getShortTimeStamp = exports.getLocationStatus = exports.getHealthMessage = exports.MonitorListStatusColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _parse_timestamp = require("../parse_timestamp");
var _constants = require("../../../../../../common/constants");
var _translations = require("../../../../../../common/translations/translations");
var _status_badge = require("./status_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/columns/monitor_status_column.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StatusColumnFlexG = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  @media (max-width: 574px) {
    min-width: 230px;
  }
`;
const getHealthMessage = status => {
  switch (status) {
    case _constants.STATUS.UP:
      return _translations.STATUS_UP_LABEL;
    case _constants.STATUS.DOWN:
      return _translations.STATUS_DOWN_LABEL;
    default:
      return null;
  }
};
exports.getHealthMessage = getHealthMessage;
const getShortTimeStamp = (timeStamp, relative = false) => {
  if (relative) {
    var _moment$locale;
    const prevLocale = (_moment$locale = _moment.default.locale()) !== null && _moment$locale !== void 0 ? _moment$locale : 'en';
    const shortLocale = _moment.default.locale(_constants.SHORT_TS_LOCALE) === _constants.SHORT_TS_LOCALE;
    if (!shortLocale) {
      _moment.default.defineLocale(_constants.SHORT_TS_LOCALE, _constants.SHORT_TIMESPAN_LOCALE);
    }
    let shortTimestamp;
    if (typeof timeStamp === 'string') {
      shortTimestamp = (0, _parse_timestamp.parseTimestamp)(timeStamp).fromNow();
    } else {
      shortTimestamp = timeStamp.fromNow();
    }

    // Reset it so, it doesn't impact other part of the app
    _moment.default.locale(prevLocale);
    return shortTimestamp;
  } else {
    if ((0, _moment.default)().diff(timeStamp, 'd') >= 1) {
      return timeStamp.format('ll LTS');
    }
    return timeStamp.format('LTS');
  }
};
exports.getShortTimeStamp = getShortTimeStamp;
const getLocationStatus = (summaryPings, status) => {
  const upPings = new Set();
  const downPings = new Set();
  summaryPings.forEach(summaryPing => {
    var _summaryPing$observer, _summaryPing$observer2, _summaryPing$observer3;
    const location = (_summaryPing$observer = summaryPing === null || summaryPing === void 0 ? void 0 : (_summaryPing$observer2 = summaryPing.observer) === null || _summaryPing$observer2 === void 0 ? void 0 : (_summaryPing$observer3 = _summaryPing$observer2.geo) === null || _summaryPing$observer3 === void 0 ? void 0 : _summaryPing$observer3.name) !== null && _summaryPing$observer !== void 0 ? _summaryPing$observer : _constants.UNNAMED_LOCATION;
    if (summaryPing.monitor.status === _constants.STATUS.UP) {
      upPings.add(location);
    } else if (summaryPing.monitor.status === _constants.STATUS.DOWN) {
      downPings.add(location);
    }
  });
  const upsMessage = upPings.size > 0 ? _i18n.i18n.translate('xpack.uptime.monitorList.statusColumn.locStatusMessage.tooltip.up', {
    defaultMessage: 'Up in {locs}',
    values: {
      locs: [...upPings].join(', ')
    }
  }) : '';
  const downMessage = downPings.size > 0 ? _i18n.i18n.translate('xpack.uptime.monitorList.statusColumn.locStatusMessage.tooltip.down', {
    defaultMessage: 'Down in {locs}',
    values: {
      locs: [...downPings].join(', ')
    }
  }) : '';

  // if monitor is down in one dns, it will be considered down so removing it from up list
  const absUpChecks = new Set([...upPings].filter(item => !downPings.has(item)));
  const totalLocations = absUpChecks.size + downPings.size;
  let statusMessage = '';
  if (status === _constants.STATUS.DOWN) {
    statusMessage = `${downPings.size}/${totalLocations}`;
  } else {
    statusMessage = `${absUpChecks.size}/${totalLocations}`;
  }
  if (totalLocations > 1) {
    return {
      statusMessage: _i18n.i18n.translate('xpack.uptime.monitorList.statusColumn.locStatusMessage.multiple', {
        defaultMessage: 'in {noLoc} locations',
        values: {
          noLoc: statusMessage
        }
      }),
      locTooltip: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 11
        }
      }, upsMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 11
        }
      }, downMessage))
    };
  }
  return {
    statusMessage: _i18n.i18n.translate('xpack.uptime.monitorList.statusColumn.locStatusMessage', {
      defaultMessage: 'in {noLoc} location',
      values: {
        noLoc: statusMessage
      }
    }),
    locTooltip: upsMessage + downMessage
  };
};
exports.getLocationStatus = getLocationStatus;
const MonitorListStatusColumn = ({
  status,
  summaryError,
  summaryPings = [],
  timestamp: tsString
}) => {
  const timestamp = (0, _parse_timestamp.parseTimestamp)(tsString);
  const {
    statusMessage,
    locTooltip
  } = getLocationStatus(summaryPings, status);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(StatusColumnFlexG, {
    alignItems: "center",
    gutterSize: "xs",
    wrap: false,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      flexBasis: 40
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_status_badge.StatusBadge, {
    status: status,
    summaryError: summaryError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "ghost",
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 13
      }
    }, locTooltip),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(PaddedText, {
    tabIndex: 0,
    size: "xs",
    color: "subdued",
    className: "eui-textNoWrap",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  }, statusMessage, ",")), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "text",
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 17
      }
    }, " ", timestamp.fromNow())), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "ghost",
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 15
      }
    }, timestamp.toLocaleString())),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    size: "xs",
    color: "subdued",
    className: "eui-textNoWrap",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }, getCheckedLabel(timestamp)))));
};
exports.MonitorListStatusColumn = MonitorListStatusColumn;
const getCheckedLabel = timestamp => {
  return _i18n.i18n.translate('xpack.uptime.monitorList.statusColumn.checkedTimestamp', {
    defaultMessage: 'Checked {timestamp}',
    values: {
      timestamp: getShortTimeStamp(timestamp)
    }
  });
};
const PaddedText = (0, _common.euiStyled)(_eui.EuiText)`
  padding-right: ${props => props.theme.eui.euiSizeXS};
`;