"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseCurrentFilters = exports.MonitorNameColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _stringify_url_params = require("../../../../lib/helper/url_params/stringify_url_params");
var _monitor_page_link = require("../../../common/monitor_page_link");
var _hooks = require("../../../../hooks");
var _use_filter_update = require("../../../../hooks/use_filter_update");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/columns/monitor_name_col.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const parseCurrentFilters = filters => {
  let parsedFilters;
  try {
    parsedFilters = new Map(JSON.parse(filters));
  } catch {
    parsedFilters = new Map();
  }
  return parsedFilters;
};
exports.parseCurrentFilters = parseCurrentFilters;
const MONITOR_TYPES = {
  browser: 'Browser',
  http: 'HTTP Ping',
  tcp: 'TCP Ping',
  icmp: 'ICMP Ping'
};
const MonitorNameColumn = ({
  summary
}) => {
  var _currFilters$get;
  const params = (0, _hooks.useGetUrlParams)();
  const linkParameters = (0, _stringify_url_params.stringifyUrlParams)(params, true);
  const currFilters = parseCurrentFilters(params.filters);
  const [filterType, setFilterType] = (0, _react.useState)((_currFilters$get = currFilters.get('monitor.type')) !== null && _currFilters$get !== void 0 ? _currFilters$get : []);
  const excludedTypeFilters = (0, _react.useMemo)(() => {
    var _currExcludedFilters$;
    const currExcludedFilters = parseCurrentFilters(params.excludedFilters);
    return (_currExcludedFilters$ = currExcludedFilters.get('monitor.type')) !== null && _currExcludedFilters$ !== void 0 ? _currExcludedFilters$ : [];
  }, [params.excludedFilters]);
  (0, _use_filter_update.useFilterUpdate)('monitor.type', filterType, excludedTypeFilters);
  const filterLabel = _i18n.i18n.translate('xpack.uptime.monitorList.monitorType.filter', {
    defaultMessage: 'Filter all monitors with type {type}',
    values: {
      type: summary.state.monitor.type
    }
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_page_link.MonitorPageLink, {
    monitorId: summary.monitor_id,
    linkParameters: linkParameters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, summary.state.monitor.name ? summary.state.monitor.name : `Unnamed - ${summary.monitor_id}`), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsMonitorNameColumnButton",
    color: "text",
    title: filterLabel,
    onClick: () => {
      setFilterType([summary.state.monitor.type]);
    },
    size: "xs",
    flush: "left",
    style: {
      border: 'none'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, MONITOR_TYPES[summary.state.monitor.type]))));
};
exports.MonitorNameColumn = MonitorNameColumn;