"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationDeprecation = exports.INTEGRATION_DEPRECATION_SESSION_STORAGE_KEY = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _reactRedux = require("react-redux");
var _has_integration_monitors = require("../../../state/api/has_integration_monitors");
var _selectors = require("../../../state/selectors");
var _integration_deprecation_callout = require("./integration_deprecation_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/integration_deprecation/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INTEGRATION_DEPRECATION_SESSION_STORAGE_KEY = exports.INTEGRATION_DEPRECATION_SESSION_STORAGE_KEY = 'SYNTHETICS_INTEGRATION_DEPRECATION_HAS_BEEN_DISMISSED';
const IntegrationDeprecation = () => {
  const monitorList = (0, _reactRedux.useSelector)(_selectors.monitorListSelector);
  const noticeHasBeenDismissed = window.sessionStorage.getItem(INTEGRATION_DEPRECATION_SESSION_STORAGE_KEY) === 'true';
  const {
    data,
    loading
  } = (0, _public.useFetcher)(() => {
    // load it when list is loaded
    if (!noticeHasBeenDismissed && monitorList.isLoaded) {
      return (0, _has_integration_monitors.getHasIntegrationMonitors)();
    }
    return undefined;
    // FIXME: Dario thinks there is a better way to do this but
    // he's getting tired and maybe the Uptime folks can fix it
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [monitorList.isLoaded]);
  const hasIntegrationMonitors = !loading && data && data.hasIntegrationMonitors;
  const [shouldShowNotice, setShouldShowNotice] = (0, _react.useState)(Boolean(hasIntegrationMonitors && !noticeHasBeenDismissed));
  const handleDismissDeprecationNotice = () => {
    window.sessionStorage.setItem(INTEGRATION_DEPRECATION_SESSION_STORAGE_KEY, 'true');
    setShouldShowNotice(false);
  };
  (0, _react.useEffect)(() => {
    setShouldShowNotice(Boolean(hasIntegrationMonitors && !noticeHasBeenDismissed));
  }, [hasIntegrationMonitors, noticeHasBeenDismissed]);
  return shouldShowNotice ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_integration_deprecation_callout.IntegrationDeprecationCallout, {
    handleDismissDeprecationNotice: handleDismissDeprecationNotice,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  })) : null;
};
exports.IntegrationDeprecation = IntegrationDeprecation;