"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToggleAlertFlyoutButtonComponent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _uptime_alerts = require("../../../../../common/constants/uptime_alerts");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/alerts/toggle_alert_flyout_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALERT_CONTEXT_MAIN_PANEL_ID = 0;
const ALERT_CONTEXT_SELECT_TYPE_PANEL_ID = 1;
const noWritePermissionsTooltipContent = _i18n.i18n.translate('xpack.uptime.alertDropdown.noWritePermissions', {
  defaultMessage: 'You need read-write access to Uptime to create alerts in this app.'
});
const ToggleAlertFlyoutButtonComponent = ({
  alertOptions,
  setAlertFlyoutVisible
}) => {
  var _kibana$services$appl, _kibana$services$appl2, _kibana$services$appl3;
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const kibana = (0, _public.useKibana)();
  const {
    services: {
      observability
    }
  } = (0, _public.useKibana)();
  const manageRulesUrl = observability.useRulesLink();
  const hasUptimeWrite = (_kibana$services$appl = (_kibana$services$appl2 = kibana.services.application) === null || _kibana$services$appl2 === void 0 ? void 0 : (_kibana$services$appl3 = _kibana$services$appl2.capabilities.uptime) === null || _kibana$services$appl3 === void 0 ? void 0 : _kibana$services$appl3.save) !== null && _kibana$services$appl !== void 0 ? _kibana$services$appl : false;
  const monitorStatusAlertContextMenuItem = {
    'aria-label': _translations.ToggleFlyoutTranslations.toggleMonitorStatusAriaLabel,
    'data-test-subj': 'xpack.synthetics.toggleAlertFlyout',
    name: _translations.ToggleFlyoutTranslations.toggleMonitorStatusContent,
    onClick: () => {
      setAlertFlyoutVisible(_uptime_alerts.CLIENT_ALERT_TYPES.MONITOR_STATUS);
      setIsOpen(false);
    }
  };
  const tlsAlertContextMenuItem = {
    'aria-label': _translations.ToggleFlyoutTranslations.toggleTlsAriaLabel,
    'data-test-subj': 'xpack.synthetics.toggleTlsAlertFlyout',
    name: _translations.ToggleFlyoutTranslations.toggleTlsContent,
    onClick: () => {
      setAlertFlyoutVisible(_uptime_alerts.CLIENT_ALERT_TYPES.TLS);
      setIsOpen(false);
    }
  };
  const managementContextItem = {
    'aria-label': _translations.ToggleFlyoutTranslations.navigateToAlertingUIAriaLabel,
    'data-test-subj': 'xpack.synthetics.navigateToAlertingUi',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsToggleAlertFlyoutButtonComponentManageRulesLink",
      color: "text",
      href: manageRulesUrl.href,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.navigateToAlertingButton.content",
      defaultMessage: "Manage rules",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    })),
    icon: 'tableOfContents'
  };
  let selectionItems = [];
  if (!alertOptions) {
    selectionItems = [monitorStatusAlertContextMenuItem, tlsAlertContextMenuItem];
  } else {
    alertOptions.forEach(option => {
      if (option === _uptime_alerts.CLIENT_ALERT_TYPES.MONITOR_STATUS) selectionItems.push(monitorStatusAlertContextMenuItem);else if (option === _uptime_alerts.CLIENT_ALERT_TYPES.TLS) selectionItems.push(tlsAlertContextMenuItem);
    });
  }
  if (selectionItems.length === 1) {
    selectionItems[0].icon = 'bell';
  }
  let panels;
  if (selectionItems.length === 1) {
    panels = [{
      id: ALERT_CONTEXT_MAIN_PANEL_ID,
      items: [...selectionItems, managementContextItem]
    }];
  } else {
    panels = [{
      id: ALERT_CONTEXT_MAIN_PANEL_ID,
      items: [{
        'aria-label': _translations.ToggleFlyoutTranslations.openAlertContextPanelAriaLabel,
        'data-test-subj': 'xpack.synthetics.openAlertContextPanel',
        name: _translations.ToggleFlyoutTranslations.openAlertContextPanelLabel,
        icon: 'bell',
        panel: ALERT_CONTEXT_SELECT_TYPE_PANEL_ID,
        toolTipContent: !hasUptimeWrite ? noWritePermissionsTooltipContent : null,
        disabled: !hasUptimeWrite
      }, managementContextItem]
    }, {
      id: ALERT_CONTEXT_SELECT_TYPE_PANEL_ID,
      title: _translations.ToggleFlyoutTranslations.toggleAlertFlyoutButtonLabel,
      items: selectionItems
    }];
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
      color: "primary",
      "aria-label": _translations.ToggleFlyoutTranslations.toggleButtonAriaLabel,
      "data-test-subj": "xpack.synthetics.alertsPopover.toggleButton",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: () => setIsOpen(!isOpen),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.alerts.toggleAlertFlyoutButtonText",
      defaultMessage: "Alerts",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 11
      }
    })),
    closePopover: () => setIsOpen(false),
    isOpen: isOpen,
    ownFocus: true,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }));
};
exports.ToggleAlertFlyoutButtonComponent = ToggleAlertFlyoutButtonComponent;