"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeExpressionSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _alert_expression_popover = require("../alert_expression_popover");
var labels = _interopRequireWildcard(require("../translations"));
var _alert_field_number = require("../alert_field_number");
var _translations2 = require("./translations");
var _time_unit_selectable = require("./time_unit_selectable");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/alerts/monitor_expressions/time_expression_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_TIMERANGE_UNIT = 'm';
const TimeRangeOptions = [{
  'aria-label': labels.SECONDS_TIME_RANGE,
  'data-test-subj': 'xpack.synthetics.alerts.monitorStatus.timerangeUnitSelectable.secondsOption',
  key: 's',
  label: labels.SECONDS
}, {
  'aria-label': labels.MINUTES_TIME_RANGE,
  'data-test-subj': 'xpack.synthetics.alerts.monitorStatus.timerangeUnitSelectable.minutesOption',
  key: 'm',
  label: labels.MINUTES
}, {
  'aria-label': labels.HOURS_TIME_RANGE,
  'data-test-subj': 'xpack.synthetics.alerts.monitorStatus.timerangeUnitSelectable.hoursOption',
  key: 'h',
  label: labels.HOURS
}, {
  'aria-label': labels.DAYS_TIME_RANGE,
  'data-test-subj': 'xpack.synthetics.alerts.monitorStatus.timerangeUnitSelectable.daysOption',
  key: 'd',
  label: labels.DAYS
}];
const TimeExpressionSelect = ({
  defaultTimerangeCount,
  defaultTimerangeUnit,
  isEnabled,
  setRuleParams
}) => {
  var _timerangeUnitOptions3, _timerangeUnitOptions4;
  const [numUnits, setNumUnits] = (0, _react.useState)(defaultTimerangeCount !== null && defaultTimerangeCount !== void 0 ? defaultTimerangeCount : 15);
  const [timerangeUnitOptions, setTimerangeUnitOptions] = (0, _react.useState)(TimeRangeOptions.map(opt => opt.key === (defaultTimerangeUnit !== null && defaultTimerangeUnit !== void 0 ? defaultTimerangeUnit : DEFAULT_TIMERANGE_UNIT) ? {
    ...opt,
    checked: 'on'
  } : opt));
  (0, _react.useEffect)(() => {
    var _timerangeUnitOptions, _timerangeUnitOptions2;
    const timerangeUnit = (_timerangeUnitOptions = (_timerangeUnitOptions2 = timerangeUnitOptions.find(({
      checked
    }) => checked === 'on')) === null || _timerangeUnitOptions2 === void 0 ? void 0 : _timerangeUnitOptions2.key) !== null && _timerangeUnitOptions !== void 0 ? _timerangeUnitOptions : 'm';
    setRuleParams('timerangeUnit', timerangeUnit);
    setRuleParams('timerangeCount', numUnits);
  }, [numUnits, timerangeUnitOptions, setRuleParams]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_expression_popover.AlertExpressionPopover, {
    "aria-label": labels.OPEN_THE_POPOVER_TIME_RANGE_VALUE,
    content: /*#__PURE__*/_react.default.createElement(_alert_field_number.AlertFieldNumber, {
      "aria-label": labels.ENTER_NUMBER_OF_TIME_UNITS,
      "data-test-subj": "xpack.synthetics.alerts.monitorStatus.timerangeValueField",
      disabled: false,
      fieldValue: numUnits,
      setFieldValue: setNumUnits,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 13
      }
    }),
    "data-test-subj": "xpack.synthetics.alerts.monitorStatus.timerangeValueExpression",
    description: labels.ENTER_NUMBER_OF_TIME_UNITS_DESCRIPTION,
    id: "timerange",
    isEnabled: isEnabled,
    value: labels.ENTER_NUMBER_OF_TIME_UNITS_VALUE(numUnits),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_expression_popover.AlertExpressionPopover, {
    "aria-label": _translations2.timeExpLabels.OPEN_TIME_POPOVER,
    content: /*#__PURE__*/_react.default.createElement(_time_unit_selectable.TimeUnitSelectable, {
      "aria-label": _translations2.timeExpLabels.SELECT_TIME_RANGE_ARIA,
      "data-test-subj": "xpack.synthetics.alerts.monitorStatus.timerangeUnitSelectable",
      headlineText: _translations2.timeExpLabels.SELECT_TIME_RANGE_HEADLINE,
      onChange: newOptions => {
        if (newOptions.reduce((acc, {
          checked
        }) => acc || checked === 'on', false)) {
          setTimerangeUnitOptions(newOptions);
        }
      },
      timeRangeOptions: timerangeUnitOptions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 13
      }
    }),
    "data-test-subj": "xpack.synthetics.alerts.monitorStatus.timerangeUnitExpression",
    description: "",
    id: "timerange-unit",
    isEnabled: isEnabled,
    value: (_timerangeUnitOptions3 = (_timerangeUnitOptions4 = timerangeUnitOptions.find(({
      checked
    }) => checked === 'on')) === null || _timerangeUnitOptions4 === void 0 ? void 0 : _timerangeUnitOptions4.label.toLowerCase()) !== null && _timerangeUnitOptions3 !== void 0 ? _timerangeUnitOptions3 : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  })));
};
exports.TimeExpressionSelect = TimeExpressionSelect;