"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FiltersExpressionsSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _translations = require("../../filter_group/translations");
var _translations2 = require("./translations");
var _uptime_data_view_context = require("../../../../contexts/uptime_data_view_context");
var _constants = require("../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/alerts/monitor_expressions/filters_expression_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  TYPE,
  TAGS,
  LOCATION,
  PORT
} = _constants.FILTER_FIELDS;
const FiltersExpressionsSelect = ({
  ruleParams,
  newFilters,
  onRemoveFilter,
  setRuleParams
}) => {
  var _alertFilters$PORT, _alertFilters$LOCATIO, _alertFilters$TYPE, _alertFilters$TAGS;
  const alertFilters = ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.filters;
  const selectedPorts = (_alertFilters$PORT = alertFilters === null || alertFilters === void 0 ? void 0 : alertFilters[PORT]) !== null && _alertFilters$PORT !== void 0 ? _alertFilters$PORT : [];
  const selectedLocations = (_alertFilters$LOCATIO = alertFilters === null || alertFilters === void 0 ? void 0 : alertFilters[LOCATION]) !== null && _alertFilters$LOCATIO !== void 0 ? _alertFilters$LOCATIO : [];
  const selectedSchemes = (_alertFilters$TYPE = alertFilters === null || alertFilters === void 0 ? void 0 : alertFilters[TYPE]) !== null && _alertFilters$TYPE !== void 0 ? _alertFilters$TYPE : [];
  const selectedTags = (_alertFilters$TAGS = alertFilters === null || alertFilters === void 0 ? void 0 : alertFilters[TAGS]) !== null && _alertFilters$TAGS !== void 0 ? _alertFilters$TAGS : [];
  const {
    dateRangeStart: from,
    dateRangeEnd: to
  } = (0, _hooks.useGetUrlParams)();
  const onFilterFieldChange = (fieldName, values) => {
    // the `filters` field is no longer a string
    if (ruleParams.filters && typeof ruleParams.filters !== 'string') {
      setRuleParams('filters', {
        ...ruleParams.filters,
        [fieldName]: values
      });
    } else {
      setRuleParams('filters', Object.assign({}, {
        [TAGS]: [],
        [PORT]: [],
        [LOCATION]: [],
        [TYPE]: []
      }, {
        [fieldName]: values !== null && values !== void 0 ? values : []
      }));
    }
  };
  const monitorFilters = [{
    ariaLabel: _translations2.filterAriaLabels.PORT,
    onFilterFieldChange,
    loading: false,
    fieldName: 'url.port',
    id: 'filter_port',
    selectedItems: selectedPorts,
    title: _translations.filterLabels.PORT,
    description: selectedPorts.length === 0 ? _translations2.alertFilterLabels.USING : _translations2.alertFilterLabels.USING_PORT,
    value: selectedPorts.length === 0 ? _translations2.alertFilterLabels.ANY_PORT : selectedPorts === null || selectedPorts === void 0 ? void 0 : selectedPorts.join(',')
  }, {
    ariaLabel: _translations2.filterAriaLabels.TAG,
    onFilterFieldChange,
    loading: false,
    fieldName: 'tags',
    id: 'filter_tags',
    selectedItems: selectedTags,
    title: _translations.filterLabels.TAG,
    description: selectedTags.length === 0 ? _translations2.alertFilterLabels.WITH : _translations2.alertFilterLabels.WITH_TAG,
    value: selectedTags.length === 0 ? _translations2.alertFilterLabels.ANY_TAG : selectedTags === null || selectedTags === void 0 ? void 0 : selectedTags.join(',')
  }, {
    ariaLabel: _translations2.filterAriaLabels.SCHEME,
    onFilterFieldChange,
    loading: false,
    fieldName: 'monitor.type',
    id: 'filter_scheme',
    selectedItems: selectedSchemes,
    title: _translations.filterLabels.SCHEME,
    description: selectedSchemes.length === 0 ? _translations2.alertFilterLabels.OF : _translations2.alertFilterLabels.OF_TYPE,
    value: selectedSchemes.length === 0 ? _translations2.alertFilterLabels.ANY_TYPE : selectedSchemes === null || selectedSchemes === void 0 ? void 0 : selectedSchemes.join(',')
  }, {
    ariaLabel: _translations2.filterAriaLabels.LOCATION,
    onFilterFieldChange,
    loading: false,
    fieldName: 'observer.geo.name',
    id: 'filter_location',
    selectedItems: selectedLocations,
    title: _translations.filterLabels.LOCATION,
    description: selectedLocations.length === 0 ? _translations2.alertFilterLabels.FROM : _translations2.alertFilterLabels.FROM_LOCATION,
    value: selectedLocations.length === 0 ? _translations2.alertFilterLabels.ANY_LOCATION : selectedLocations === null || selectedLocations === void 0 ? void 0 : selectedLocations.join(',')
  }];
  const [isOpen, setIsOpen] = (0, _react.useState)({
    filter_port: false,
    filter_tags: false,
    filter_scheme: false,
    filter_location: false
  });
  const filtersToDisplay = monitorFilters.filter(curr => curr.selectedItems.length > 0 || (newFilters === null || newFilters === void 0 ? void 0 : newFilters.includes(curr.fieldName)));
  const dataView = (0, _uptime_data_view_context.useUptimeDataView)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, filtersToDisplay.map(({
    description,
    id,
    title,
    value,
    fieldName,
    ariaLabel,
    selectedItems
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    key: id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }, dataView && /*#__PURE__*/_react.default.createElement(_public.FieldValueSuggestions, {
    filters: [],
    key: fieldName,
    dataViewTitle: dataView.title,
    sourceField: fieldName,
    label: title,
    onChange: vals => {
      onFilterFieldChange(fieldName, vals);
    },
    selectedValue: selectedItems,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      "aria-label": ariaLabel,
      color: 'success',
      "data-test-subj": 'uptimeCreateStatusAlert.' + id,
      description: description,
      value: value,
      onClick: () => setIsOpen({
        ...isOpen,
        [id]: !isOpen[id]
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 21
      }
    }),
    forceOpen: isOpen[id],
    setForceOpen: () => {
      setIsOpen({
        ...isOpen,
        [id]: !isOpen[id]
      });
    },
    asCombobox: false,
    cardinalityField: "monitor.id",
    time: {
      from,
      to
    },
    allowExclusions: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "observabilitySolutionFiltersExpressionsSelectButton",
    "aria-label": _translations2.alertFilterLabels.REMOVE_FILTER_LABEL(title),
    iconType: "trash",
    color: "danger",
    onClick: () => {
      onRemoveFilter(fieldName);
      onFilterFieldChange(fieldName, []);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  }))));
};
exports.FiltersExpressionsSelect = FiltersExpressionsSelect;