"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AvailabilityExpressionSelect = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _alert_expression_popover = require("../alert_expression_popover");
var labels = _interopRequireWildcard(require("../translations"));
var _alert_field_number = require("../alert_field_number");
var _time_unit_selectable = require("./time_unit_selectable");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/alerts/monitor_expressions/availability_expression_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimeRangeOptions = [{
  'aria-label': labels.DAYS_TIME_RANGE,
  'data-test-subj': 'xpack.synthetics.alerts.monitorStatus.availability.timerangeUnit.daysOption',
  key: 'd',
  label: labels.DAYS
}, {
  'aria-label': labels.WEEKS_TIME_RANGE,
  'data-test-subj': 'xpack.synthetics.alerts.monitorStatus.availability.timerangeUnit.weeksOption',
  key: 'w',
  label: labels.WEEKS
}, {
  'aria-label': labels.MONTHS_TIME_RANGE,
  'data-test-subj': 'xpack.synthetics.alerts.monitorStatus.availability.timerangeUnit.monthsOption',
  key: 'M',
  label: labels.MONTHS
}, {
  'aria-label': labels.YEARS_TIME_RANGE,
  'data-test-subj': 'xpack.synthetics.alerts.monitorStatus.availability.timerangeUnit.yearsOption',
  key: 'y',
  label: labels.YEARS
}];
const DEFAULT_RANGE = 30;
const DEFAULT_TIMERANGE_UNIT = 'd';
const DEFAULT_THRESHOLD = '99';
const isThresholdInvalid = n => isNaN(n) || n <= 0 || n > 100;
const AvailabilityExpressionSelect = ({
  ruleParams,
  isOldAlert,
  setRuleParams,
  hasFilters
}) => {
  var _ruleParams$availabil, _ruleParams$availabil2, _ruleParams$availabil3, _ruleParams$availabil4, _ruleParams$availabil5, _ruleParams$availabil6, _ruleParams$shouldChe, _timerangeUnitOptions, _timerangeUnitOptions2;
  const [range, setRange] = (0, _react.useState)((_ruleParams$availabil = ruleParams === null || ruleParams === void 0 ? void 0 : (_ruleParams$availabil2 = ruleParams.availability) === null || _ruleParams$availabil2 === void 0 ? void 0 : _ruleParams$availabil2.range) !== null && _ruleParams$availabil !== void 0 ? _ruleParams$availabil : DEFAULT_RANGE);
  const [rangeUnit, setRangeUnit] = (0, _react.useState)((_ruleParams$availabil3 = ruleParams === null || ruleParams === void 0 ? void 0 : (_ruleParams$availabil4 = ruleParams.availability) === null || _ruleParams$availabil4 === void 0 ? void 0 : _ruleParams$availabil4.rangeUnit) !== null && _ruleParams$availabil3 !== void 0 ? _ruleParams$availabil3 : DEFAULT_TIMERANGE_UNIT);
  const [threshold, setThreshold] = (0, _react.useState)((_ruleParams$availabil5 = ruleParams === null || ruleParams === void 0 ? void 0 : (_ruleParams$availabil6 = ruleParams.availability) === null || _ruleParams$availabil6 === void 0 ? void 0 : _ruleParams$availabil6.threshold) !== null && _ruleParams$availabil5 !== void 0 ? _ruleParams$availabil5 : DEFAULT_THRESHOLD);
  const [isEnabled, setIsEnabled] = (0, _react.useState)(// if an older version of alert is displayed, this expression should default to disabled
  (_ruleParams$shouldChe = ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.shouldCheckAvailability) !== null && _ruleParams$shouldChe !== void 0 ? _ruleParams$shouldChe : !isOldAlert);
  const [timerangeUnitOptions, setTimerangeUnitOptions] = (0, _react.useState)(TimeRangeOptions.map(opt => opt.key === DEFAULT_TIMERANGE_UNIT ? {
    ...opt,
    checked: 'on'
  } : opt));
  const thresholdIsInvalid = isThresholdInvalid(Number(threshold));
  (0, _react.useEffect)(() => {
    if (thresholdIsInvalid) {
      setRuleParams('availability', undefined);
      setRuleParams('shouldCheckAvailability', false);
    } else if (isEnabled) {
      setRuleParams('shouldCheckAvailability', true);
      setRuleParams('availability', {
        range,
        rangeUnit,
        threshold
      });
    } else {
      setRuleParams('shouldCheckAvailability', false);
    }
  }, [isEnabled, range, rangeUnit, setRuleParams, threshold, thresholdIsInvalid]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "availabilityRangeEnabled",
    label: labels.ENTER_AVAILABILITY_RANGE_ENABLED,
    checked: isEnabled,
    onChange: () => setIsEnabled(!isEnabled),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_expression_popover.AlertExpressionPopover, {
    "aria-label": labels.ENTER_AVAILABILITY_THRESHOLD_ARIA_LABEL,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "syntheticsAvailabilityExpressionSelectFieldText",
      isInvalid: thresholdIsInvalid,
      value: threshold,
      onChange: e => {
        setThreshold(e.target.value);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 13
      }
    }),
    "data-test-subj": "xpack.synthetics.alerts.monitorStatus.availability.threshold",
    description: hasFilters ? labels.ENTER_AVAILABILITY_THRESHOLD_DESCRIPTION : labels.ENTER_ANY_AVAILABILITY_THRESHOLD_DESCRIPTION,
    id: "threshold",
    isEnabled: isEnabled,
    isInvalid: thresholdIsInvalid,
    value: labels.ENTER_AVAILABILITY_THRESHOLD_VALUE(threshold),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_expression_popover.AlertExpressionPopover, {
    "aria-label": labels.ENTER_AVAILABILITY_RANGE_POPOVER_ARIA_LABEL,
    content: /*#__PURE__*/_react.default.createElement(_alert_field_number.AlertFieldNumber, {
      "aria-label": labels.ENTER_AVAILABILITY_RANGE_UNITS_ARIA_LABEL,
      "data-test-subj": "xpack.synthetics.alerts.monitorStatus.availability.timerangeValueField",
      disabled: false,
      fieldValue: range,
      setFieldValue: setRange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 17
      }
    }),
    "data-test-subj": "xpack.synthetics.alerts.monitorStatus.availability.timerangeExpression",
    description: labels.ENTER_AVAILABILITY_RANGE_UNITS_DESCRIPTION,
    id: "range",
    isEnabled: isEnabled,
    value: `${range}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_expression_popover.AlertExpressionPopover, {
    "aria-label": "xpack.synthetics.alerts.monitorStatus.availability.timerangeUnit",
    content: /*#__PURE__*/_react.default.createElement(_time_unit_selectable.TimeUnitSelectable, {
      "aria-label": labels.ENTER_AVAILABILITY_RANGE_SELECT_ARIA,
      "data-test-subj": "xpack.synthetics.alerts.monitorStatus.availability.timerangeUnit.select",
      headlineText: labels.ENTER_AVAILABILITY_RANGE_SELECT_HEADLINE
      // TODO: this should not be `any`
      ,
      onChange: newOptions => {
        // TODO: this should not be `any`
        const checkedOption = newOptions.find(({
          checked
        }) => checked === 'on');
        if (checkedOption) {
          setTimerangeUnitOptions(newOptions);
          setRangeUnit(checkedOption.key);
        }
      },
      timeRangeOptions: timerangeUnitOptions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 17
      }
    }),
    "data-test-subj": "xpack.synthetics.alerts.monitorStatus.availability.timerangeUnit",
    description: "",
    id: "availability-unit",
    isEnabled: isEnabled,
    value: (_timerangeUnitOptions = (_timerangeUnitOptions2 = timerangeUnitOptions.find(({
      checked
    }) => checked === 'on')) === null || _timerangeUnitOptions2 === void 0 ? void 0 : _timerangeUnitOptions2.label.toLowerCase()) !== null && _timerangeUnitOptions !== void 0 ? _timerangeUnitOptions : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 13
    }
  })))));
};
exports.AvailabilityExpressionSelect = AvailabilityExpressionSelect;