"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyAlertComponent = AnomalyAlertComponent;
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _get_severity = require("@kbn/ml-anomaly-utils/get_severity");
var _get_severity_color = require("@kbn/ml-anomaly-utils/get_severity_color");
var _translations = require("./translations");
var _alert_expression_popover = require("../alert_expression_popover");
var _select_severity = require("./select_severity");
var _selectors = require("../../../../state/selectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/alerts/anomaly_alert/anomaly_alert.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Individual deep imports to not consume the whole package bundle.
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AnomalyAlertComponent({
  setRuleParams,
  ruleParams,
  id,
  stackVersion
}) {
  const [severity, setSeverity] = (0, _react.useState)(_select_severity.DEFAULT_SEVERITY);
  const monitorIdStore = (0, _reactRedux.useSelector)(_selectors.monitorIdSelector);
  const monitorId = monitorIdStore || (ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.monitorId);
  (0, _react.useEffect)(() => {
    setRuleParams('monitorId', monitorId);
  }, [monitorId, setRuleParams]);
  (0, _react.useEffect)(() => {
    setRuleParams('severity', severity.val);
  }, [severity, setRuleParams]);
  (0, _react.useEffect)(() => {
    if (!id && stackVersion && !ruleParams.stackVersion) {
      setRuleParams('stackVersion', stackVersion);
    }
  }, [ruleParams, id, stackVersion, setRuleParams]);
  (0, _react.useEffect)(() => {
    if (ruleParams.severity !== undefined) {
      setSeverity(_select_severity.SEVERITY_OPTIONS.find(({
        val
      }) => val === ruleParams.severity));
    }

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'column',
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
    description: _translations.AnomalyTranslations.whenMonitor,
    value: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      className: "eui-displayInlineBlock",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 17
      }
    }, monitorId)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_expression_popover.AlertExpressionPopover, {
    "aria-label": _translations.AnomalyTranslations.scoreAriaLabel,
    content: /*#__PURE__*/_react.default.createElement(_select_severity.SelectSeverity, {
      "data-test-subj": "uptimeAnomalySeverityValue",
      value: severity,
      onChange: setSeverity,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 15
      }
    }),
    "data-test-subj": 'uptimeAnomalySeverity',
    description: _translations.AnomalyTranslations.hasAnomalyWithSeverity,
    id: "severity",
    value: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      style: {
        textTransform: 'capitalize'
      },
      color: (0, _get_severity_color.getSeverityColor)(severity.val),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 15
      }
    }, (0, _get_severity.getSeverity)(severity.val).label),
    isEnabled: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }));
}