"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertQueryBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _query_bar = require("../../query_bar/query_bar");
var labels = _interopRequireWildcard(require("../translations"));
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/alerts/alert_query_bar/query_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertQueryBar = ({
  query = '',
  onChange
}) => {
  const dataView = (0, _hooks.useUptimeDataView)();
  const {
    services
  } = (0, _public.useKibana)();
  const {
    appName,
    unifiedSearch: {
      ui: {
        QueryStringInput
      }
    }
  } = services;
  const [inputVal, setInputVal] = (0, _react.useState)(query);
  (0, _react.useEffect)(() => {
    onChange(query);
    setInputVal(query);
  }, [onChange, query]);
  return /*#__PURE__*/_react.default.createElement(QueryStringInput, {
    indexPatterns: dataView ? [dataView] : [],
    iconType: "search",
    isClearable: true,
    onChange: queryN => {
      setInputVal(queryN === null || queryN === void 0 ? void 0 : queryN.query);
      if ((0, _query_bar.isValidKuery)(queryN === null || queryN === void 0 ? void 0 : queryN.query)) {
        // we want to submit when user clears or paste a complete kuery
        onChange(queryN.query);
      }
    },
    onSubmit: queryN => {
      if (queryN) onChange(queryN.query);
    },
    query: {
      query: inputVal,
      language: 'kuery'
    },
    "aria-label": labels.ALERT_KUERY_BAR_ARIA,
    dataTestSubj: "xpack.synthetics.alerts.monitorStatus.filterBar",
    autoSubmit: true,
    disableLanguageSwitcher: true,
    isInvalid: !!(inputVal && !query),
    placeholder: _i18n.i18n.translate('xpack.uptime.alerts.searchPlaceholder.kql', {
      defaultMessage: 'Filter using kql syntax'
    }),
    appName: appName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  });
};
exports.AlertQueryBar = AlertQueryBar;