"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sidebar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("./constants");
var _waterfall_chart = require("../context/waterfall_chart");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/synthetics/waterfall/components/sidebar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Sidebar = ({
  items,
  render
}) => {
  const {
    onSidebarClick
  } = (0, _waterfall_chart.useWaterfallContext)();
  const handleSidebarClick = (0, _react.useMemo)(() => onSidebarClick, [onSidebarClick]);
  return /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarWrapper, {
    grow: _constants.SIDEBAR_GROW_SIZE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarContainer, {
    height: items.length * _constants.FIXED_AXIS_HEIGHT,
    "data-test-subj": "wfSidebarContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarContainerInnerPanel, {
    paddingSize: "none",
    hasBorder: false,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarContainerFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }, items.map((item, index) => {
    return /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarFlexItem, {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 17
      }
    }, render(item, index, handleSidebarClick));
  })))));
};
exports.Sidebar = Sidebar;