"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDetailContainer = exports.NO_STEP_DATA = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_monitor_breadcrumb = require("./use_monitor_breadcrumb");
var _waterfall_chart_container = require("./waterfall/waterfall_chart_container");
var _step_detail_page = require("../../../../pages/synthetics/step_detail_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/synthetics/step_detail/step_detail_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NO_STEP_DATA = exports.NO_STEP_DATA = _i18n.i18n.translate('xpack.uptime.synthetics.stepDetail.noData', {
  defaultMessage: 'No data could be found for this step'
});
const StepDetailContainer = ({
  checkGroup,
  stepIndex
}) => {
  const {
    activeStep,
    journey
  } = (0, _step_detail_page.useStepDetailPage)();
  (0, _use_monitor_breadcrumb.useMonitorBreadcrumb)({
    details: journey === null || journey === void 0 ? void 0 : journey.details,
    activeStep,
    performanceBreakDownView: true
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (!journey || journey.loading) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 13
    }
  }))), journey && !activeStep && !journey.loading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 15
    }
  }, NO_STEP_DATA)))), journey && activeStep && !journey.loading && /*#__PURE__*/_react.default.createElement(_waterfall_chart_container.WaterfallChartContainer, {
    checkGroup: checkGroup,
    stepIndex: stepIndex,
    activeStep: activeStep,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }));
};
exports.StepDetailContainer = StepDetailContainer;