"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorRedirects = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _ping_redirects = require("../../ping_list/ping_redirects");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/status_details/status_bar/monitor_redirects.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorRedirects = ({
  monitorStatus
}) => {
  var _monitorStatus$http, _monitorStatus$http$r, _list$length;
  const list = monitorStatus === null || monitorStatus === void 0 ? void 0 : (_monitorStatus$http = monitorStatus.http) === null || _monitorStatus$http === void 0 ? void 0 : (_monitorStatus$http$r = _monitorStatus$http.response) === null || _monitorStatus$http$r === void 0 ? void 0 : _monitorStatus$http$r.redirects;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: "euiLink euiLink--primary",
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    "data-test-subj": "uptimeMonitorRedirectInfo",
    iconType: "arrowDown",
    iconSide: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.uptime.monitorList.redirects.title.number', {
    defaultMessage: '{number}',
    values: {
      number: (_list$length = list === null || list === void 0 ? void 0 : list.length) !== null && _list$length !== void 0 ? _list$length : 0
    }
  })));
  return list ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, "Redirects"), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    anchorPosition: "downLeft",
    closePopover: () => setIsPopoverOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_ping_redirects.PingRedirects, {
    monitorStatus: monitorStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }))) : null;
};
exports.MonitorRedirects = MonitorRedirects;