"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withResponsiveWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/common/higher_order/responsive_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ResponsiveWrapper = _styledComponents.default.div`
  margin-left: 120px;
  @media (max-width: 950px) {
    margin-left: 48px;
  }
  @media (max-width: 767px) {
    margin-left: 12px;
    margin-top: 40px;
  }
`;
/**
 * HOC that wraps a component in either a responsive div or an EuiPanel.
 * @param Component The component to wrap.
 */
const withResponsiveWrapper = Component => ({
  isResponsive,
  ...rest
}) => isResponsive ? /*#__PURE__*/_react.default.createElement(ResponsiveWrapper, {
  "data-test-subj": "uptimeWithResponsiveWrapper--wrapper",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, rest, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 37,
    columnNumber: 9
  }
}))) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  paddingSize: "m",
  hasBorder: true,
  "data-test-subj": "uptimeWithResponsiveWrapper--panel",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, rest, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 9
  }
})));
exports.withResponsiveWrapper = withResponsiveWrapper;