"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerESDeprecationRoutes = registerESDeprecationRoutes;
var _upgradeAssistantPkgServer = require("@kbn/upgrade-assistant-pkg-server");
var _constants = require("../../common/constants");
var _es_deprecations_status = require("../lib/es_deprecations_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerESDeprecationRoutes({
  config: {
    featureSet,
    dataSourceExclusions
  },
  router,
  lib: {
    handleEsError
  },
  log,
  current,
  cleanupReindexOperations
}) {
  router.get({
    path: `${_constants.API_BASE_PATH}/es_deprecations`,
    security: {
      authz: {
        enabled: false,
        reason: 'Relies on es and saved object clients for authorization'
      }
    },
    validate: false
  }, (0, _upgradeAssistantPkgServer.versionCheckHandlerWrapper)(current.major)(async ({
    core
  }, request, response) => {
    try {
      const {
        elasticsearch: {
          client
        }
      } = await core;
      const status = await (0, _es_deprecations_status.getESUpgradeStatus)(client.asCurrentUser, {
        featureSet,
        dataSourceExclusions
      });
      const indexNames = [...status.migrationsDeprecations, ...status.enrichedHealthIndicators].filter(({
        index
      }) => typeof index !== 'undefined').map(({
        index
      }) => index);
      await cleanupReindexOperations(indexNames);
      return response.ok({
        body: status
      });
    } catch (error) {
      log.error(error);
      return handleEsError({
        error,
        response
      });
    }
  }));
}