"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAppRoutes = registerAppRoutes;
var _upgradeAssistantPkgServer = require("@kbn/upgrade-assistant-pkg-server");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractMissingIndexPrivileges = (privilegesObject = {}) => Object.keys(privilegesObject).reduce((privileges, privilegeName) => {
  if (Object.values(privilegesObject[privilegeName]).some(e => !e)) {
    privileges.push(privilegeName);
  }
  return privileges;
}, []);
const extractMissingClusterPrivileges = (privilegesObject = {}) => Object.keys(privilegesObject).reduce((privileges, privilegeName) => {
  if (!privilegesObject[privilegeName]) {
    privileges.push(privilegeName);
  }
  return privileges;
}, []);
function registerAppRoutes({
  router,
  lib: {
    handleEsError
  },
  config: {
    isSecurityEnabled
  },
  current
}) {
  router.get({
    path: `${_constants.API_BASE_PATH}/privileges`,
    security: {
      authz: {
        enabled: false,
        reason: 'Relies on es client for authorization'
      }
    },
    validate: false
  }, (0, _upgradeAssistantPkgServer.versionCheckHandlerWrapper)(current.major)(async ({
    core
  }, request, response) => {
    const {
      elasticsearch: {
        client
      }
    } = await core;
    const privilegesResult = {
      hasAllPrivileges: true,
      missingPrivileges: {
        index: [],
        cluster: []
      }
    };
    if (!isSecurityEnabled()) {
      return response.ok({
        body: privilegesResult
      });
    }
    try {
      const {
        has_all_requested: hasAllPrivileges,
        index,
        cluster
      } = await client.asCurrentUser.security.hasPrivileges({
        cluster: _constants.APP_LOGS_COUNT_CLUSTER_PRIVILEGES,
        index: [{
          names: [_constants.DEPRECATION_LOGS_INDEX],
          privileges: _constants.APP_LOGS_COUNT_INDEX_PRIVILEGES
        }]
      });
      if (!hasAllPrivileges) {
        privilegesResult.missingPrivileges.index = extractMissingIndexPrivileges(index);
        privilegesResult.missingPrivileges.cluster = extractMissingClusterPrivileges(cluster);
      }
      privilegesResult.hasAllPrivileges = hasAllPrivileges;
      return response.ok({
        body: privilegesResult
      });
    } catch (error) {
      return handleEsError({
        error,
        response
      });
    }
  }));
}