"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsDeprecationError = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  permissionsError: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecationErrors.permissionsErrorMessage', {
    defaultMessage: 'You are not authorized to view Elasticsearch deprecation issues.'
  }),
  partiallyUpgradedWarning: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecationErrors.partiallyUpgradedWarningMessage', {
    defaultMessage: 'Upgrade Kibana to the same version as your Elasticsearch cluster. One or more nodes in the cluster is running a different version than Kibana.'
  }),
  upgradedMessage: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecationErrors.upgradedWarningMessage', {
    defaultMessage: 'All Elasticsearch nodes have been upgraded.'
  }),
  loadingError: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecationErrors.loadingErrorMessage', {
    defaultMessage: 'Could not retrieve Elasticsearch deprecation issues.'
  })
};
const getEsDeprecationError = error => {
  var _error$attributes, _error$attributes2;
  if (error.statusCode === 403) {
    return {
      code: 'unauthorized_error',
      message: i18nTexts.permissionsError
    };
  } else if ((error === null || error === void 0 ? void 0 : error.statusCode) === 426 && ((_error$attributes = error.attributes) === null || _error$attributes === void 0 ? void 0 : _error$attributes.allNodesUpgraded) === false) {
    return {
      code: 'partially_upgraded_error',
      message: i18nTexts.partiallyUpgradedWarning
    };
  } else if ((error === null || error === void 0 ? void 0 : error.statusCode) === 426 && ((_error$attributes2 = error.attributes) === null || _error$attributes2 === void 0 ? void 0 : _error$attributes2.allNodesUpgraded) === true) {
    return {
      code: 'upgraded_error',
      message: i18nTexts.upgradedMessage
    };
  } else {
    return {
      code: 'request_error',
      message: i18nTexts.loadingError
    };
  }
};
exports.getEsDeprecationError = getEsDeprecationError;