"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../../common/constants");
var _app_context = require("../../app_context");
var _ui_metric = require("../../lib/ui_metric");
var _backup_step = require("./backup_step");
var _fix_issues_step = require("./fix_issues_step");
var _upgrade_step = require("./upgrade_step");
var _migrate_system_indices = require("./migrate_system_indices");
var _logs_step = require("./logs_step");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/overview/overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Overview = exports.Overview = (0, _reactRouterDom.withRouter)(({
  history
}) => {
  const {
    featureSet: {
      migrateSystemIndices
    },
    services: {
      breadcrumbs,
      core: {
        docLinks
      }
    },
    plugins: {
      cloud
    },
    kibanaVersionInfo: {
      currentMajor,
      currentMinor,
      currentPatch
    }
  } = (0, _app_context.useAppContext)();
  const currentVersion = `${currentMajor}.${currentMinor}.${currentPatch}`;
  (0, _react.useEffect)(() => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.LOADED, _ui_metric.UIM_OVERVIEW_PAGE_LOAD);
  }, []);
  (0, _react.useEffect)(() => {
    breadcrumbs.setBreadcrumbs('overview');
  }, [breadcrumbs]);
  const [completedStepsMap, setCompletedStepsMap] = (0, _react.useState)({
    backup: false,
    migrate_system_indices: false,
    fix_issues: false,
    logs: false
  });
  const isStepComplete = step => completedStepsMap[step];
  const setCompletedStep = (step, isCompleted) => {
    setCompletedStepsMap({
      ...completedStepsMap,
      [step]: isCompleted
    });
  };
  const versionTooltipContent = () => {
    if (currentVersion >= _constants.MIN_VERSION_TO_UPGRADE_TO_LATEST) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "right",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.overview.latestMinVersionTooltip",
        defaultMessage: "Upgrading to v{latestVersion} requires v{minVersionToUpgradeToLatest}.",
        values: {
          latestVersion: _constants.LATEST_VERSION,
          minVersionToUpgradeToLatest: _constants.MIN_VERSION_TO_UPGRADE_TO_LATEST
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 11
        }
      }),
      type: "info",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: true,
    "data-test-subj": "overview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    color: "transparent",
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    "data-test-subj": "overviewPageHeader",
    pageTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.pageTitle', {
      defaultMessage: 'Upgrade Assistant'
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.overview.versionInfo",
      defaultMessage: "Current version: {currentVersion} | Latest available version: {latestVersion} {versionTooltip}",
      values: {
        currentVersion: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 113,
            columnNumber: 33
          }
        }, currentVersion),
        latestVersion: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 114,
            columnNumber: 32
          }
        }, _constants.LATEST_VERSION),
        versionTooltip: versionTooltipContent()
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.overview.linkToReleaseNotes",
    defaultMessage: "{linkToReleaseNotes}",
    values: {
      linkToReleaseNotes: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "whatsNewLink",
        href: docLinks.links.elasticsearch.latestReleaseHighlights,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.overview.minorOfLatestMajorReleaseNotes",
        defaultMessage: "What's new in version v{latestVersion}",
        values: {
          latestVersion: _constants.LATEST_VERSION
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 21
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [(0, _backup_step.getBackupStep)({
      cloud,
      isComplete: isStepComplete('backup'),
      setIsComplete: setCompletedStep.bind(null, 'backup')
    }), migrateSystemIndices && (0, _migrate_system_indices.getMigrateSystemIndicesStep)({
      docLinks,
      isComplete: isStepComplete('migrate_system_indices'),
      setIsComplete: setCompletedStep.bind(null, 'migrate_system_indices')
    }), (0, _fix_issues_step.getFixIssuesStep)({
      isComplete: isStepComplete('fix_issues'),
      setIsComplete: setCompletedStep.bind(null, 'fix_issues')
    }), (0, _logs_step.getLogsStep)({
      isComplete: isStepComplete('logs'),
      setIsComplete: setCompletedStep.bind(null, 'logs')
    }), (0, _upgrade_step.getUpgradeStep)()].filter(Boolean),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  })));
});