"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsDeprecationIssuesPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _app_context = require("../../../../app_context");
var _get_es_deprecation_error = require("../../../../lib/get_es_deprecation_error");
var _deprecation_issues_panel = require("./deprecation_issues_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/overview/fix_issues_step/components/es_deprecation_issues_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EsDeprecationIssuesPanel = ({
  setIsFixed
}) => {
  var _esDeprecations$migra, _esDeprecations$migra2, _esDeprecations$migra3, _esDeprecations$migra4, _esDeprecations$migra5, _esDeprecations$migra6;
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  const {
    data: esDeprecations,
    isLoading,
    error
  } = api.useLoadEsDeprecations();
  const criticalDeprecationsCount = (_esDeprecations$migra = esDeprecations === null || esDeprecations === void 0 ? void 0 : (_esDeprecations$migra2 = esDeprecations.migrationsDeprecations) === null || _esDeprecations$migra2 === void 0 ? void 0 : (_esDeprecations$migra3 = _esDeprecations$migra2.filter(deprecation => deprecation.level === 'critical')) === null || _esDeprecations$migra3 === void 0 ? void 0 : _esDeprecations$migra3.length) !== null && _esDeprecations$migra !== void 0 ? _esDeprecations$migra : 0;
  const warningDeprecationsCount = (_esDeprecations$migra4 = esDeprecations === null || esDeprecations === void 0 ? void 0 : (_esDeprecations$migra5 = esDeprecations.migrationsDeprecations) === null || _esDeprecations$migra5 === void 0 ? void 0 : (_esDeprecations$migra6 = _esDeprecations$migra5.filter(deprecation => deprecation.level !== 'critical')) === null || _esDeprecations$migra6 === void 0 ? void 0 : _esDeprecations$migra6.length) !== null && _esDeprecations$migra4 !== void 0 ? _esDeprecations$migra4 : 0;
  const errorMessage = error && (0, _get_es_deprecation_error.getEsDeprecationError)(error).message;
  return /*#__PURE__*/_react.default.createElement(_deprecation_issues_panel.DeprecationIssuesPanel, {
    "data-test-subj": "esStatsPanel",
    deprecationSource: "Elasticsearch",
    linkUrl: "/es_deprecations",
    criticalDeprecationsCount: criticalDeprecationsCount,
    warningDeprecationsCount: warningDeprecationsCount,
    isLoading: isLoading,
    errorMessage: errorMessage,
    setIsFixed: setIsFixed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  });
};
exports.EsDeprecationIssuesPanel = EsDeprecationIssuesPanel;