"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsDeprecationsTableCells = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _shared = require("../shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/es_deprecations_table_cells.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  manualCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.defaultDeprecation.manualCellLabel', {
    defaultMessage: 'Resolve manually'
  })
};
const EsDeprecationsTableCells = ({
  resolutionTableCell,
  fieldName,
  deprecation,
  actionsTableCell
}) => {
  var _deprecation$fieldNam;
  // "Status column"
  if (fieldName === 'level') {
    return /*#__PURE__*/_react.default.createElement(_shared.DeprecationBadge, {
      level: deprecation.level,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 12
      }
    });
  }

  // "Issue" column
  if (fieldName === 'message') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, deprecation.message);
  }

  // "Type" column
  if (fieldName === 'type') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _constants.DEPRECATION_TYPE_MAP[deprecation.type]);
  }

  // "Resolution column"
  if (fieldName === 'correctiveAction') {
    if (resolutionTableCell) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, resolutionTableCell);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("em", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }, i18nTexts.manualCellLabel));
  }

  // "Actions column"
  if (fieldName === 'actions') {
    if (actionsTableCell) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, actionsTableCell);
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }

  // Default behavior: render value or empty string if undefined
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_deprecation$fieldNam = deprecation[fieldName]) !== null && _deprecation$fieldNam !== void 0 ? _deprecation$fieldNam : '');
};
exports.EsDeprecationsTableCells = EsDeprecationsTableCells;