"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsDeprecationsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _app_context = require("../../app_context");
var _deprecation_types = require("./deprecation_types");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/es_deprecations_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const i18nTexts = {
  refreshButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.refreshButtonLabel', {
    defaultMessage: 'Refresh'
  }),
  noDeprecationsMessage: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.noDeprecationsMessage', {
    defaultMessage: 'No Elasticsearch deprecation issues found'
  }),
  typeFilterLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.typeFilterLabel', {
    defaultMessage: 'Type'
  }),
  statusFilterLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.statusFilterLabel', {
    defaultMessage: 'Status'
  }),
  searchPlaceholderLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.searchPlaceholderLabel', {
    defaultMessage: 'Filter'
  })
};
const cellToLabelMap = {
  level: {
    label: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.statusColumnTitle', {
      defaultMessage: 'Status'
    }),
    width: '8px',
    sortable: true,
    align: 'left'
  },
  message: {
    label: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.issueColumnTitle', {
      defaultMessage: 'Issue'
    }),
    width: '28px',
    sortable: true,
    align: 'left'
  },
  type: {
    label: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.typeColumnTitle', {
      defaultMessage: 'Type'
    }),
    width: '10px',
    sortable: true,
    align: 'left'
  },
  index: {
    label: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.nameColumnTitle', {
      defaultMessage: 'Name'
    }),
    width: '20px',
    sortable: true,
    align: 'left'
  },
  correctiveAction: {
    label: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.resolutionColumnTitle', {
      defaultMessage: 'Resolution'
    }),
    width: '20px',
    sortable: true,
    align: 'left'
  },
  actions: {
    label: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    width: '8px',
    sortable: false,
    align: 'right'
  }
};
const cellTypes = Object.keys(cellToLabelMap);
const pageSizeOptions = _constants.PAGINATION_CONFIG.pageSizeOptions;
const renderTableRow = (deprecation, mlUpgradeModeEnabled, index) => {
  var _deprecation$correcti;
  switch ((_deprecation$correcti = deprecation.correctiveAction) === null || _deprecation$correcti === void 0 ? void 0 : _deprecation$correcti.type) {
    case 'mlSnapshot':
      return /*#__PURE__*/_react.default.createElement(_deprecation_types.MlSnapshotsTableRow, {
        deprecation: deprecation,
        rowFieldNames: cellTypes,
        mlUpgradeModeEnabled: mlUpgradeModeEnabled,
        index: index,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 9
        }
      });
    case 'indexSetting':
      return /*#__PURE__*/_react.default.createElement(_deprecation_types.IndexSettingsTableRow, {
        deprecation: deprecation,
        rowFieldNames: cellTypes,
        index: index,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 9
        }
      });
    case 'clusterSetting':
      return /*#__PURE__*/_react.default.createElement(_deprecation_types.ClusterSettingsTableRow, {
        deprecation: deprecation,
        rowFieldNames: cellTypes,
        index: index,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 9
        }
      });
    case 'reindex':
    case 'unfreeze':
      return /*#__PURE__*/_react.default.createElement(_deprecation_types.IndexTableRow, {
        deprecation: deprecation,
        rowFieldNames: cellTypes,
        index: index,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 14
        }
      });
    case 'healthIndicator':
      return /*#__PURE__*/_react.default.createElement(_deprecation_types.HealthIndicatorTableRow, {
        deprecation: deprecation,
        rowFieldNames: cellTypes,
        index: index,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 170,
          columnNumber: 9
        }
      });
    case 'dataStream':
      return /*#__PURE__*/_react.default.createElement(_deprecation_types.DataStreamTableRow, {
        deprecation: deprecation,
        rowFieldNames: cellTypes,
        index: index,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 9
        }
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_deprecation_types.DefaultTableRow, {
        deprecation: deprecation,
        rowFieldNames: cellTypes,
        index: index,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 14
        }
      });
  }
};
const getSortedItems = (deprecations, sortConfig) => {
  const {
    isSortAscending,
    sortField
  } = sortConfig;
  const sorted = (0, _lodash.sortBy)(deprecations, [deprecation => {
    if (sortField === 'level') {
      // Critical deprecations should take precedence in ascending order
      return deprecation.level === 'critical' ? 0 : 1;
    }
    return deprecation[sortField];
  }]);
  return isSortAscending ? sorted : sorted.reverse();
};
const statusFilterOptions = [{
  value: 'critical',
  name: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.filter.critical', {
    defaultMessage: 'Critical'
  })
}, {
  value: 'warning',
  name: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.filter.warning', {
    defaultMessage: 'Warning'
  })
}];
const EsDeprecationsTable = ({
  deprecations = [],
  reload
}) => {
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  const {
    data
  } = api.useLoadMlUpgradeMode();
  const mlUpgradeModeEnabled = !!(data !== null && data !== void 0 && data.mlUpgradeModeEnabled);
  const [sortConfig, setSortConfig] = (0, _react.useState)({
    isSortAscending: true,
    sortField: 'level'
  });
  const [itemsPerPage, setItemsPerPage] = (0, _react.useState)(_constants.PAGINATION_CONFIG.initialPageSize);
  const [currentPageIndex, setCurrentPageIndex] = (0, _react.useState)(0);
  const [searchQuery, setSearchQuery] = (0, _react.useState)(_eui.EuiSearchBar.Query.MATCH_ALL);
  const [searchError, setSearchError] = (0, _react.useState)(undefined);
  const [filteredDeprecations, setFilteredDeprecations] = (0, _react.useState)(getSortedItems(deprecations, sortConfig));
  const pager = (0, _react.useMemo)(() => new _eui.Pager(deprecations.length, itemsPerPage, currentPageIndex), [currentPageIndex, deprecations, itemsPerPage]);
  const visibleDeprecations = (0, _react.useMemo)(() => filteredDeprecations.slice(pager.firstItemIndex, pager.lastItemIndex + 1), [filteredDeprecations, pager]);
  const handleSort = (0, _react.useCallback)(fieldName => {
    const newSortConfig = {
      isSortAscending: sortConfig.sortField === fieldName ? !sortConfig.isSortAscending : true,
      sortField: fieldName
    };
    setSortConfig(newSortConfig);
  }, [sortConfig]);
  const handleSearch = (0, _react.useCallback)(({
    query,
    error
  }) => {
    if (error) {
      setSearchError(error);
    } else {
      setSearchError(undefined);
      setSearchQuery(query);
    }
  }, []);
  (0, _react.useEffect)(() => {
    const {
      setTotalItems,
      goToPageIndex
    } = pager;
    const deprecationsFilteredByQuery = _eui.EuiSearchBar.Query.execute(searchQuery, deprecations);
    const deprecationsSortedByFieldType = getSortedItems(deprecationsFilteredByQuery, sortConfig);
    setTotalItems(deprecationsSortedByFieldType.length);
    setFilteredDeprecations(deprecationsSortedByFieldType);

    // Reset pagination if the filtered results return a different length
    if (deprecationsSortedByFieldType.length !== filteredDeprecations.length) {
      goToPageIndex(0);
    }
  }, [deprecations, sortConfig, pager, searchQuery, filteredDeprecations.length]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "searchBarContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: {
      placeholder: i18nTexts.searchPlaceholderLabel,
      incremental: true
    },
    filters: [{
      type: 'field_value_selection',
      field: 'level',
      name: i18nTexts.statusFilterLabel,
      multiSelect: false,
      options: statusFilterOptions
    }, {
      type: 'field_value_selection',
      field: 'type',
      name: i18nTexts.typeFilterLabel,
      multiSelect: false,
      options: Object.keys(_constants.DEPRECATION_TYPE_MAP).map(type => ({
        value: type,
        name: _constants.DEPRECATION_TYPE_MAP[type]
      }))
    }],
    onChange: handleSearch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "refresh",
    onClick: reload,
    "data-test-subj": "refreshButton",
    key: "refreshButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 11
    }
  }, i18nTexts.refreshButtonLabel))), searchError && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "invalidSearchQueryMessage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "danger",
    title: `Invalid search: ${searchError.message}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    "data-test-subj": "esDeprecationsTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 9
    }
  }, Object.entries(cellToLabelMap).map(([fieldName, cell]) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
      width: cell.width,
      key: cell.label,
      onSort: () => handleSort(fieldName),
      isSorted: sortConfig.sortField === fieldName,
      isSortAscending: sortConfig.isSortAscending,
      readOnly: !cell.sortable,
      align: cell.align,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 358,
        columnNumber: 15
      }
    }, cell.label);
  })), filteredDeprecations.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    "data-test-subj": "noDeprecationsRow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    align: "center",
    colSpan: cellTypes.length,
    mobileOptions: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 15
    }
  }, i18nTexts.noDeprecationsMessage))) : /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 11
    }
  }, visibleDeprecations.map((deprecation, index) => {
    // Calculate the absolute index in the full deprecations array
    // This ensures stable keys across pagination
    // For example: with 10 items per page:
    // - Page 1: firstItemIndex=0, keys will be deprecation-row-0 to deprecation-row-9
    // - Page 2: firstItemIndex=10, keys will be deprecation-row-10 to deprecation-row-19
    // This prevents React from reusing components incorrectly when navigating between pages
    const absoluteIndex = pager.firstItemIndex + index;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: `deprecation-row-${absoluteIndex}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 396,
        columnNumber: 17
      }
    }, renderTableRow(deprecation, mlUpgradeModeEnabled, absoluteIndex));
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 405,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    "data-test-subj": "esDeprecationsPagination",
    activePage: pager.getCurrentPageIndex(),
    itemsPerPage: pager.itemsPerPage,
    itemsPerPageOptions: pageSizeOptions,
    pageCount: pager.getTotalPages(),
    onChangeItemsPerPage: setItemsPerPage,
    onChangePage: setCurrentPageIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 7
    }
  }));
};
exports.EsDeprecationsTable = EsDeprecationsTable;