"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlSnapshotsTableRowCells = exports.MlSnapshotsTableRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _app_context = require("../../../../app_context");
var _shared_imports = require("../../../../../shared_imports");
var _es_deprecations_table_cells = require("../../es_deprecations_table_cells");
var _resolution_table_cell = require("./resolution_table_cell");
var _flyout = require("./flyout");
var _context = require("./context");
var _actions_table_cell = require("./actions_table_cell");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/ml_snapshots/table_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  useGlobalFlyout
} = _shared_imports.GlobalFlyout;
const MlSnapshotsTableRowCells = ({
  rowFieldNames,
  deprecation,
  index
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const snapshotState = (0, _context.useMlSnapshotContext)();
  const {
    addContent: addContentToGlobalFlyout,
    removeContent: removeContentFromGlobalFlyout
  } = useGlobalFlyout();
  const closeFlyout = (0, _react.useCallback)(() => {
    setShowFlyout(false);
    removeContentFromGlobalFlyout('mlFlyout');
  }, [removeContentFromGlobalFlyout]);
  (0, _react.useEffect)(() => {
    if (showFlyout) {
      addContentToGlobalFlyout({
        id: 'mlFlyout',
        Component: _flyout.FixSnapshotsFlyout,
        props: {
          deprecation,
          closeFlyout,
          ...snapshotState
        },
        flyoutProps: {
          onClose: closeFlyout,
          className: 'eui-textBreakWord',
          'data-test-subj': 'mlSnapshotDetails',
          'aria-labelledby': 'mlSnapshotDetailsFlyoutTitle'
        }
      });
    }
  }, [snapshotState, addContentToGlobalFlyout, showFlyout, deprecation, closeFlyout]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    "data-test-subj": "deprecationTableRow",
    key: `deprecation-row-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, rowFieldNames.map(field => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      key: field,
      truncateText: false,
      "data-test-subj": `mlTableCell-${field}`,
      align: field === 'actions' ? 'right' : 'left',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_es_deprecations_table_cells.EsDeprecationsTableCells, {
      fieldName: field,
      deprecation: deprecation,
      resolutionTableCell: /*#__PURE__*/_react.default.createElement(_resolution_table_cell.MlSnapshotsResolutionCell, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 36
        }
      }),
      actionsTableCell: /*#__PURE__*/_react.default.createElement(_actions_table_cell.MlSnapshotsActionsCell, {
        openFlyout: () => setShowFlyout(true),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 33
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 13
      }
    }));
  }));
};
exports.MlSnapshotsTableRowCells = MlSnapshotsTableRowCells;
const MlSnapshotsTableRow = props => {
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  return /*#__PURE__*/_react.default.createElement(_context.MlSnapshotsStatusProvider, {
    snapshotId: props.deprecation.correctiveAction.snapshotId,
    jobId: props.deprecation.correctiveAction.jobId,
    mlUpgradeModeEnabled: props.mlUpgradeModeEnabled,
    api: api,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(MlSnapshotsTableRowCells, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  })));
};
exports.MlSnapshotsTableRow = MlSnapshotsTableRow;