"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlSnapshotsResolutionCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _context = require("./context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/ml_snapshots/resolution_table_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  upgradeInProgressText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.upgradeInProgressText', {
    defaultMessage: 'Upgrade in progress…'
  }),
  deleteInProgressText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.deletingButtonLabel', {
    defaultMessage: 'Deletion in progress…'
  }),
  upgradeCompleteText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.upgradeCompleteText', {
    defaultMessage: 'Upgrade complete'
  }),
  deleteCompleteText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.deleteCompleteText', {
    defaultMessage: 'Deletion complete'
  }),
  upgradeFailedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.upgradeFailedText', {
    defaultMessage: 'Upgrade failed'
  }),
  deleteFailedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.deleteFailedText', {
    defaultMessage: 'Deletion failed'
  })
};
const MlSnapshotsResolutionCell = () => {
  const {
    snapshotState
  } = (0, _context.useMlSnapshotContext)();
  if (snapshotState.status === 'in_progress') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "mlActionResolutionCell",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    }, snapshotState.action === 'delete' ? i18nTexts.deleteInProgressText : i18nTexts.upgradeInProgressText)));
  }
  if (snapshotState.status === 'complete') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "mlActionResolutionCell",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "checkInCircleFilled",
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    }, snapshotState.action === 'delete' ? i18nTexts.deleteCompleteText : i18nTexts.upgradeCompleteText)));
  }
  if (snapshotState.status === 'error') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "mlActionResolutionCell",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warningFilled",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }, snapshotState.action === 'delete' ? i18nTexts.deleteFailedText : i18nTexts.upgradeFailedText)));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
exports.MlSnapshotsResolutionCell = MlSnapshotsResolutionCell;