"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSettingsResolutionCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/index_settings/resolution_table_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  deleteInProgressText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indexSettings.deletingButtonLabel', {
    defaultMessage: 'Settings removal in progress…'
  }),
  deleteCompleteText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indexSettings.deleteCompleteText', {
    defaultMessage: 'Deprecated settings removed'
  }),
  deleteFailedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indexSettings.deleteFailedText', {
    defaultMessage: 'Settings removal failed'
  }),
  resolutionText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indexSettings.resolutionText', {
    defaultMessage: 'Remove settings'
  }),
  resolutionTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indexSettings.resolutionTooltipLabel', {
    defaultMessage: 'Resolve this issue by removing settings from this index. This issue can be resolved automatically.'
  })
};
const IndexSettingsResolutionCell = ({
  status
}) => {
  const {
    statusType
  } = status;
  if (statusType === 'in_progress') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "indexSettingsResolutionStatusCell",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("em", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 13
      }
    }, i18nTexts.deleteInProgressText))));
  }
  if (statusType === 'complete') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "indexSettingsResolutionStatusCell",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "checkInCircleFilled",
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    }, i18nTexts.deleteCompleteText)));
  }
  if (statusType === 'error') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "indexSettingsResolutionStatusCell",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warningFilled",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }, i18nTexts.deleteFailedText)));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
exports.IndexSettingsResolutionCell = IndexSettingsResolutionCell;