"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamReadonlyModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _moment = _interopRequireDefault(require("moment"));
var _ui_metric = require("../../../../../lib/ui_metric");
var _messages = require("./messages");
var _initializing_step = require("../../../common/initializing_step");
var _confirm = require("./steps/confirm");
var _checklist = require("./steps/checklist");
var _completed_step = require("./steps/completed/completed_step");
var _use_migration_step = require("../use_migration_step");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/data_streams/flyout/modal_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DATE_FORMAT = 'dddd, MMMM Do YYYY, h:mm:ss a';
const DataStreamReadonlyModal = ({
  loadDataStreamMetadata,
  migrationState,
  startReadonly,
  cancelReadonly,
  closeModal,
  deprecation
}) => {
  const {
    status,
    migrationWarnings,
    errorMessage,
    resolutionType,
    meta
  } = migrationState;
  const [modalStep, setModalStep] = (0, _use_migration_step.useMigrationStep)(status, loadDataStreamMetadata);
  const {
    index
  } = deprecation;
  const onStartReadonly = (0, _react.useCallback)(async () => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_DATA_STREAM_START_READONLY_CLICK);
    await startReadonly();
  }, [startReadonly]);
  const onStopReadonly = (0, _react.useCallback)(async () => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_DATA_STREAM_STOP_READONLY_CLICK);
    await cancelReadonly();
  }, [cancelReadonly]);
  const {
    lastIndexCreationDateFormatted
  } = (0, _react.useMemo)(() => {
    if (!meta) {
      return {
        lastIndexCreationDateFormatted: _messages.containerMessages.unknownMessage
      };
    }
    return {
      lastIndexCreationDateFormatted: typeof meta.lastIndexRequiringUpgradeCreationDate === 'number' ? `${(0, _moment.default)(meta.lastIndexRequiringUpgradeCreationDate).format(DATE_FORMAT)}` : 'Unknown'
    };
  }, [meta]);
  const modalContent = (0, _react.useMemo)(() => {
    switch (modalStep) {
      case 'initializing':
        return /*#__PURE__*/_react.default.createElement(_initializing_step.InitializingStep, {
          errorMessage: errorMessage,
          type: "dataStream",
          mode: "modal",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 77,
            columnNumber: 16
          }
        });
      case 'confirm':
        {
          if (!meta || !resolutionType) {
            return /*#__PURE__*/_react.default.createElement(_initializing_step.InitializingStep, {
              errorMessage: errorMessage || _messages.containerMessages.errorLoadingDataStreamInfo,
              type: "dataStream",
              mode: "modal",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 81,
                columnNumber: 13
              }
            });
          }
          return /*#__PURE__*/_react.default.createElement(_confirm.ConfirmMigrationReadonlyFlyoutStep, {
            warnings: (migrationWarnings !== null && migrationWarnings !== void 0 ? migrationWarnings : []).filter(warning => warning.resolutionType === resolutionType),
            meta: meta,
            closeModal: closeModal,
            startAction: () => onStartReadonly(),
            lastIndexCreationDateFormatted: lastIndexCreationDateFormatted,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 90,
              columnNumber: 11
            }
          });
        }
      case 'inProgress':
        {
          if (!resolutionType) {
            return /*#__PURE__*/_react.default.createElement(_initializing_step.InitializingStep, {
              errorMessage: errorMessage || _messages.containerMessages.errorLoadingDataStreamInfo,
              type: "dataStream",
              mode: "modal",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 104,
                columnNumber: 13
              }
            });
          }
          return /*#__PURE__*/_react.default.createElement(_checklist.ChecklistModalStep, {
            closeModal: closeModal,
            executeAction: () => {
              setModalStep('confirm');
            },
            migrationState: migrationState,
            cancelAction: () => onStopReadonly(),
            dataStreamName: index,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 113,
              columnNumber: 11
            }
          });
        }
      case 'completed':
        {
          return /*#__PURE__*/_react.default.createElement(_completed_step.MigrationCompletedModalStep, {
            meta: meta,
            resolutionType: resolutionType,
            close: closeModal,
            dataStreamName: index,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 126,
              columnNumber: 11
            }
          });
        }
    }
  }, [closeModal, errorMessage, index, lastIndexCreationDateFormatted, meta, migrationState, migrationWarnings, modalStep, onStartReadonly, onStopReadonly, resolutionType, setModalStep]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    "data-test-subj": "updateIndexModal",
    maxWidth: true,
    css: {
      minWidth: 750
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  }, modalContent);
};
exports.DataStreamReadonlyModal = DataStreamReadonlyModal;