"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeprecationLogging = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _app_context = require("../../../app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  enabledMessage: _i18n.i18n.translate('xpack.upgradeAssistant.overview.deprecationLogs.enabledToastMessage', {
    defaultMessage: 'Deprecated API requests will be logged and indexed.'
  }),
  disabledMessage: _i18n.i18n.translate('xpack.upgradeAssistant.overview.deprecationLogs.disabledToastMessage', {
    defaultMessage: 'Deprecated API requests will not be logged.'
  })
};
const useDeprecationLogging = () => {
  const {
    services: {
      api,
      core: {
        notifications
      }
    }
  } = (0, _app_context.useAppContext)();
  const {
    data,
    error: fetchError,
    isLoading,
    resendRequest
  } = api.useLoadDeprecationLogging();
  const [isDeprecationLogIndexingEnabled, setIsDeprecationLogIndexingEnabled] = (0, _react.useState)(false);
  const [isUpdating, setIsUpdating] = (0, _react.useState)(false);
  const [onlyDeprecationLogWritingEnabled, setOnlyDeprecationLogWritingEnabled] = (0, _react.useState)(false);
  const [updateError, setUpdateError] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (!isLoading && data) {
      const {
        isDeprecationLogIndexingEnabled: isIndexingEnabled,
        isDeprecationLoggingEnabled
      } = data;
      setIsDeprecationLogIndexingEnabled(isIndexingEnabled);
      if (!isIndexingEnabled && isDeprecationLoggingEnabled) {
        setOnlyDeprecationLogWritingEnabled(true);
      }
    }
  }, [data, isLoading]);
  const toggleLogging = async () => {
    setIsUpdating(true);
    const {
      data: updatedLoggingState,
      error: updateDeprecationError
    } = await api.updateDeprecationLogging({
      isEnabled: !isDeprecationLogIndexingEnabled
    });
    setIsUpdating(false);
    setOnlyDeprecationLogWritingEnabled(false);
    if (updateDeprecationError) {
      setUpdateError(updateDeprecationError);
    } else if (updatedLoggingState) {
      setIsDeprecationLogIndexingEnabled(updatedLoggingState.isDeprecationLogIndexingEnabled);
      notifications.toasts.addSuccess(updatedLoggingState.isDeprecationLogIndexingEnabled ? i18nTexts.enabledMessage : i18nTexts.disabledMessage);
    }
  };
  return {
    isDeprecationLogIndexingEnabled,
    isLoading,
    isUpdating,
    toggleLogging,
    fetchError,
    updateError,
    resendRequest,
    onlyDeprecationLogWritingEnabled
  };
};
exports.useDeprecationLogging = useDeprecationLogging;