"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeprecationDataView = exports.DiscoverExternalLinks = void 0;
var _react = _interopRequireWildcard(require("react"));
var _esQuery = require("@kbn/es-query");
var _i18nReact = require("@kbn/i18n-react");
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _app_context = require("../../../app_context");
var _ui_metric = require("../../../lib/ui_metric");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecation_logs/fix_deprecation_logs/external_links.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getDeprecationDataView = async dataService => {
  const results = await dataService.dataViews.find(_constants.DEPRECATION_LOGS_INDEX_PATTERN);
  // Since the find might return also results with wildcard matchers we need to find the
  // index pattern that has an exact match with our title.
  const deprecationDataView = results.find(result => result.title === _constants.DEPRECATION_LOGS_INDEX_PATTERN);
  if (deprecationDataView) {
    return deprecationDataView;
  } else {
    // When creating the data view, we need to be careful when creating a data view
    // for an index that doesnt exist. Since the deprecation logs data stream is only created
    // when a deprecation log is indexed it could be possible that it might not exist at the
    // time we need to render the DiscoveryAppLink.
    // So in order to avoid those errors we need to make sure that the data view is created
    // with allowNoIndex and that we skip fetching fields to from the source index.
    const override = false;
    const skipFetchFields = true;
    // prettier-ignore
    const newDataView = await dataService.dataViews.createAndSave({
      title: _constants.DEPRECATION_LOGS_INDEX_PATTERN,
      allowNoIndex: true
    }, override, skipFetchFields);
    return newDataView;
  }
};
exports.getDeprecationDataView = getDeprecationDataView;
const DiscoverAppLink = ({
  checkpoint,
  deprecationDataView,
  isButtonFormat
}) => {
  const {
    services: {
      data: dataService
    },
    plugins: {
      share
    }
  } = (0, _app_context.useAppContext)();
  const [discoveryUrl, setDiscoveryUrl] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const getDiscoveryUrl = async () => {
      const locator = share.url.locators.get('DISCOVER_APP_LOCATOR');
      if (!locator) {
        return;
      }
      const field = deprecationDataView.getFieldByName(_constants.DEPRECATION_LOGS_ORIGIN_FIELD);
      let filters = [];
      if (field !== undefined) {
        const filter = (0, _esQuery.buildPhrasesFilter)(field, [..._constants.APPS_WITH_DEPRECATION_LOGS], deprecationDataView);
        filter.meta.negate = true;
        filters = [filter];
      }
      const url = await (locator === null || locator === void 0 ? void 0 : locator.getUrl({
        indexPatternId: deprecationDataView.id,
        query: {
          language: 'kuery',
          query: `@timestamp > "${checkpoint}"`
        },
        filters
      }));
      setDiscoveryUrl(url);
    };
    getDiscoveryUrl();
  }, [dataService, checkpoint, share.url.locators, deprecationDataView]);
  if (discoveryUrl === undefined) {
    return null;
  }
  const handleClick = () => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_DISCOVER_CLICK);
  };
  const content = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.overview.viewDiscoverResultsAction",
    defaultMessage: "Analyze logs in Discover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  });
  return isButtonFormat ?
  /*#__PURE__*/
  // eslint-disable-next-line @elastic/eui/href-or-on-click
  _react.default.createElement(_eui.EuiButton, {
    href: discoveryUrl,
    onClick: handleClick,
    "data-test-subj": "viewDiscoverLogsButton",
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 5
    }
  }, content) :
  /*#__PURE__*/
  // eslint-disable-next-line @elastic/eui/href-or-on-click
  _react.default.createElement(_eui.EuiLink, {
    href: discoveryUrl,
    onClick: handleClick,
    "data-test-subj": "viewDiscoverLogs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, " ", content));
};
const DiscoverExternalLinks = ({
  checkpoint,
  showInfoParagraph,
  isButtonFormat
}) => {
  const {
    services: {
      data: dataService
    },
    plugins: {
      share
    }
  } = (0, _app_context.useAppContext)();
  const [deprecationDataView, setDeprecationDataView] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const getDataView = async () => {
      const dataView = await getDeprecationDataView(dataService);
      setDeprecationDataView(dataView);
    };
    getDataView();
  }, [dataService, checkpoint, share.url.locators]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 5
    }
  }, showInfoParagraph && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.overview.observe.discoveryDescription",
    defaultMessage: "Search and filter the deprecation logs to understand the types of changes you need to make.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  })), deprecationDataView ? /*#__PURE__*/_react.default.createElement(DiscoverAppLink, {
    checkpoint: checkpoint,
    deprecationDataView: deprecationDataView,
    isButtonFormat: isButtonFormat,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 9
    }
  }) : null);
};
exports.DiscoverExternalLinks = DiscoverExternalLinks;