"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamMigrationStatus = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let DataStreamMigrationStatus = exports.DataStreamMigrationStatus = /*#__PURE__*/function (DataStreamMigrationStatus) {
  DataStreamMigrationStatus[DataStreamMigrationStatus["notStarted"] = 0] = "notStarted";
  DataStreamMigrationStatus[DataStreamMigrationStatus["inProgress"] = 1] = "inProgress";
  DataStreamMigrationStatus[DataStreamMigrationStatus["completed"] = 2] = "completed";
  DataStreamMigrationStatus[DataStreamMigrationStatus["failed"] = 3] = "failed";
  DataStreamMigrationStatus[DataStreamMigrationStatus["cancelled"] = 4] = "cancelled";
  DataStreamMigrationStatus[DataStreamMigrationStatus["fetchFailed"] = 5] = "fetchFailed";
  return DataStreamMigrationStatus;
}({});
/**
 * ES Requests Types (untyped in the ES Client)
 */
// Merged but not into our client version yet.
// https://github.com/elastic/elasticsearch-specification/blob/main/specification/migrate/get_reindex_status/MigrateGetReindexStatusResponse.ts