"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esIndicesStateCheck = void 0;
var _get_index_state = require("./get_index_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const esIndicesStateCheck = async (esClient, indices) => {
  const response = await esClient.indices.resolveIndex({
    name: '*',
    expand_wildcards: 'all'
  });
  return indices.reduce((acc, index) => {
    acc[index] = (0, _get_index_state.getIndexState)(index, response);
    return acc;
  }, {});
};
exports.esIndicesStateCheck = esIndicesStateCheck;