"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDataPopover = NoDataPopover;
exports.strings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/query_string_input/no_data_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NO_DATA_POPOVER_STORAGE_KEY = 'data.noDataPopover';
const strings = exports.strings = {
  getNoDataPopoverContent: () => _i18n.i18n.translate('unifiedSearch.noDataPopover.content', {
    defaultMessage: "This time range doesn't contain any data. Increase or adjust the time range to see more fields and create charts."
  }),
  getNoDataPopoverSubtitle: () => _i18n.i18n.translate('unifiedSearch.noDataPopover.subtitle', {
    defaultMessage: 'Tip'
  }),
  getNoDataPopoverTitle: () => _i18n.i18n.translate('unifiedSearch.noDataPopover.title', {
    defaultMessage: 'Empty dataset'
  }),
  getNoDataPopoverDismissAction: () => _i18n.i18n.translate('unifiedSearch.noDataPopover.dismissAction', {
    defaultMessage: "Don't show again"
  })
};
function NoDataPopover({
  showNoDataPopover,
  storage,
  children
}) {
  const [noDataPopoverDismissed, setNoDataPopoverDismissed] = (0, _react.useState)(() => Boolean(storage.get(NO_DATA_POPOVER_STORAGE_KEY)));
  const [noDataPopoverVisible, setNoDataPopoverVisible] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (showNoDataPopover && !noDataPopoverDismissed) {
      setNoDataPopoverVisible(true);
    }
  }, [noDataPopoverDismissed, showNoDataPopover]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    onFinish: () => {},
    closePopover: () => {
      setNoDataPopoverVisible(false);
    },
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      css: {
        maxWidth: 300
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 11
      }
    }, strings.getNoDataPopoverContent())),
    minWidth: 300,
    anchorPosition: "downCenter",
    step: 1,
    stepsTotal: 1,
    isStepOpen: noDataPopoverVisible,
    subtitle: strings.getNoDataPopoverSubtitle(),
    title: strings.getNoDataPopoverTitle(),
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      flush: "right",
      color: "text",
      "data-test-subj": "noDataPopoverDismissButton",
      onClick: () => {
        storage.set(NO_DATA_POPOVER_STORAGE_KEY, true);
        setNoDataPopoverDismissed(true);
        setNoDataPopoverVisible(false);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }, strings.getNoDataPopoverDismissAction()),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    onFocus: () => {
      setNoDataPopoverVisible(false);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, children));
}