"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _esQuery = require("@kbn/es-query");
var _mlStringHash = require("@kbn/ml-string-hash");
var _filter_badge = require("../../filter_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/filter_bar/filter_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const FilterView = ({
  filter,
  readOnly,
  iconOnClick,
  onClick,
  valueLabel,
  fieldLabel,
  errorMessage,
  filterLabelStatus,
  hideAlias,
  dataViews,
  ...rest
}) => {
  const [ref, innerText] = (0, _eui.useInnerText)();
  const filterString = readOnly ? _i18n.i18n.translate('unifiedSearch.filter.filterBar.filterString', {
    defaultMessage: 'Filter: {innerText}.',
    values: {
      innerText
    }
  }) : _i18n.i18n.translate('unifiedSearch.filter.filterBar.filterActionsMessage', {
    defaultMessage: 'Filter: {innerText}. Select for more filter actions.',
    values: {
      innerText
    }
  });
  let title = errorMessage || filterString;
  if ((0, _esQuery.isFilterPinned)(filter)) {
    title = `${_i18n.i18n.translate('unifiedSearch.filter.filterBar.pinnedFilterPrefix', {
      defaultMessage: 'Pinned'
    })} ${title}`;
  }
  if (filter.meta.disabled) {
    title = `${_i18n.i18n.translate('unifiedSearch.filter.filterBar.disabledFilterPrefix', {
      defaultMessage: 'Disabled'
    })} ${title}`;
  }
  const sharedProps = {
    color: 'hollow',
    tabIndex: 0
  };
  const badgeProps = readOnly ?
  // prevent native tooltip for read-only filter pulls by setting title to undefined
  {
    ...sharedProps,
    title: undefined
  } : {
    ...sharedProps,
    title,
    // use native tooltip for non-read-only filter pills
    iconType: 'cross',
    iconSide: 'right',
    iconOnClick,
    iconOnClickAriaLabel: _i18n.i18n.translate('unifiedSearch.filter.filterBar.filterItemBadgeIconAriaLabel', {
      defaultMessage: 'Delete {filter}',
      values: {
        filter: innerText
      }
    }),
    onClick,
    onClickAriaLabel: _i18n.i18n.translate('unifiedSearch.filter.filterBar.filterItemBadgeAriaLabel', {
      defaultMessage: 'Filter actions'
    })
  };
  const FilterPill = () => /*#__PURE__*/_react.default.createElement(_filter_badge.FilterBadge, (0, _extends2.default)({
    filter: filter,
    dataViews: dataViews,
    valueLabel: valueLabel,
    filterLabelStatus: filterLabelStatus,
    hideAlias: hideAlias
  }, badgeProps, rest, {
    "data-test-subj": `filter-badge-${(0, _mlStringHash.stringHash)(innerText || '')} ${rest['data-test-subj']}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  }));
  return readOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    ref: ref,
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(FilterPill, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }))) : /*#__PURE__*/_react.default.createElement("span", {
    ref: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(FilterPill, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }));
};
exports.FilterView = FilterView;