"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withCloseFilterEditorConfirmModal = withCloseFilterEditorConfirmModal;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _esQuery = require("@kbn/es-query");
var _react = _interopRequireWildcard(require("react"));
var _close_confirm_modal = require("./close_confirm_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/filter_bar/filter_editor/with_close_confirm_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isQueryDslFilter = filter => {
  return 'queryDsl' in filter && 'customLabel' in filter;
};
const isQueryDslFilterChanged = (original, updated) => original.queryDsl !== updated.queryDsl || original.customLabel !== updated.customLabel;
function withCloseFilterEditorConfirmModal(WrappedComponent) {
  return function (props) {
    const [actionsOnClose, setActionsOnClose] = (0, _react.useState)();
    const [showConfirmModal, setShowConfirmModal] = (0, _react.useState)(false);
    const [updatedFilter, setUpdatedFilter] = (0, _react.useState)();
    const [originalFilter, setOriginalFilter] = (0, _react.useState)();
    const onCancelModal = (0, _react.useCallback)(() => {
      setShowConfirmModal(false);
    }, [setShowConfirmModal]);
    const onConfirmModal = (0, _react.useCallback)(() => {
      setShowConfirmModal(false);
      actionsOnClose === null || actionsOnClose === void 0 ? void 0 : actionsOnClose.map(action => action());
    }, [actionsOnClose, setShowConfirmModal]);
    const onCloseFilterPopover = (0, _react.useCallback)(actions => {
      const filtersAreNotEqual = updatedFilter && originalFilter && (isQueryDslFilter(updatedFilter) && isQueryDslFilterChanged(originalFilter.queryDslFilter, updatedFilter) || !isQueryDslFilter(updatedFilter) && !(0, _esQuery.compareFilters)(originalFilter.filter, updatedFilter, {
        index: true,
        alias: true
      }));
      if (filtersAreNotEqual) {
        setShowConfirmModal(true);
        setActionsOnClose(actions);
      } else {
        actions === null || actions === void 0 ? void 0 : actions.map(action => action());
      }
    }, [originalFilter, updatedFilter, setShowConfirmModal, setActionsOnClose]);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(WrappedComponent, (0, _extends2.default)({}, props, {
      onCloseFilterPopover: onCloseFilterPopover,
      onLocalFilterCreate: setOriginalFilter,
      onLocalFilterUpdate: setUpdatedFilter,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    })), showConfirmModal && /*#__PURE__*/_react.default.createElement(_close_confirm_modal.CloseFilterEditorConfirmModal, {
      onCancel: onCancelModal,
      onConfirm: onConfirmModal,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 11
      }
    }));
  };
}