"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhraseValueInput = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _calculateWidthFromCharCount = require("@kbn/calculate-width-from-char-count");
var _generic_combo_box = require("./generic_combo_box");
var _phrase_suggestor = require("./phrase_suggestor");
var _value_input_type = require("./value_input_type");
var _helpers = require("./lib/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/filter_bar/filter_editor/phrase_value_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class PhraseValueInputUI extends _phrase_suggestor.PhraseSuggestorUI {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "inputRef", null);
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.isSuggestingValues() ? this.renderWithSuggestions() : /*#__PURE__*/_react.default.createElement(_value_input_type.ValueInputType, {
      disabled: this.props.disabled,
      compressed: this.props.compressed,
      fullWidth: this.props.fullWidth,
      placeholder: this.props.intl.formatMessage({
        id: 'unifiedSearch.filter.filterEditor.valueInputPlaceholder',
        defaultMessage: 'Enter a value'
      }),
      onBlur: this.props.onBlur,
      value: this.props.value,
      onChange: this.props.onChange,
      field: this.props.field,
      isInvalid: this.props.invalid,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 11
      }
    }));
  }
  renderWithSuggestions() {
    const {
      suggestions,
      isLoading
    } = this.state;
    const {
      value,
      intl,
      onChange,
      fullWidth
    } = this.props;
    // there are cases when the value is a number, this would cause an exception
    const valueAsStr = String(value);
    const options = value ? (0, _lodash.uniq)([valueAsStr, ...suggestions]) : suggestions;
    const panelMinWidth = (0, _calculateWidthFromCharCount.calculateWidthFromEntries)(options);
    return /*#__PURE__*/_react.default.createElement(StringComboBox, {
      async: true,
      isLoading: isLoading,
      inputRef: ref => {
        this.inputRef = ref;
      },
      isDisabled: this.props.disabled,
      fullWidth: fullWidth,
      compressed: this.props.compressed,
      placeholder: intl.formatMessage({
        id: 'unifiedSearch.filter.filterEditor.valueSelectPlaceholder',
        defaultMessage: 'Select a value'
      }),
      "aria-label": intl.formatMessage({
        id: 'unifiedSearch.filter.filterEditor.valueSelectPlaceholder',
        defaultMessage: 'Select a value'
      }),
      options: options,
      getLabel: option => option,
      selectedOptions: value ? [valueAsStr] : [],
      onChange: ([newValue = '']) => {
        onChange(newValue);
      },
      onSearchChange: this.onSearchChange,
      onCreateOption: onChange,
      isClearable: false,
      "data-test-subj": "filterParamsComboBox phraseParamsComboxBox",
      singleSelection: _helpers.SINGLE_SELECTION_AS_TEXT_PROPS,
      truncationProps: _helpers.MIDDLE_TRUNCATION_PROPS,
      inputPopoverProps: {
        panelMinWidth,
        anchorPosition: 'downRight'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 7
      }
    });
  }
}
function StringComboBox(props) {
  return (0, _generic_combo_box.GenericComboBox)(props);
}
const PhraseValueInput = exports.PhraseValueInput = (0, _i18nReact.injectI18n)((0, _public.withKibana)(PhraseValueInputUI));