"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenericComboBox = GenericComboBox;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _generic_combo_box = require("./generic_combo_box.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/filter_bar/filter_editor/generic_combo_box.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * A generic combo box. Instead of accepting a set of options that contain a `label`, it accepts
 * any type of object. It also accepts a `getLabel` function that each object will be sent through
 * to get the label to be passed to the combo box. The `onChange` will trigger with the actual
 * selected objects, rather than an option object.
 */
function GenericComboBox(props) {
  const {
    options,
    selectedOptions,
    getLabel,
    onChange,
    ...otherProps
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const labels = options.map(getLabel);
  const euiOptions = labels.map(label => ({
    label
  }));
  const selectedEuiOptions = selectedOptions.filter(option => {
    return options.indexOf(option) !== -1;
  }).map(option => {
    return euiOptions[options.indexOf(option)];
  });
  const onComboBoxChange = newOptions => {
    const newValues = newOptions.map(({
      label
    }) => {
      return options[labels.indexOf(label)];
    });
    onChange(newValues);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    options: euiOptions,
    className: (0, _generic_combo_box.genericComboBoxStyle)(euiTheme),
    selectedOptions: selectedEuiOptions,
    onChange: onComboBoxChange,
    sortMatchesBy: "startsWith"
  }, otherProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }));
}