"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterBadge = FilterBadge;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _react2 = require("@emotion/react");
var _filter_badge_group = require("./filter_badge_group");
var _filter_badge = require("./filter_badge.styles");
var _i18n = require("./i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/filter_badge/filter_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function FilterBadge({
  filter,
  dataViews,
  valueLabel,
  hideAlias,
  filterLabelStatus,
  readOnly,
  ...rest
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!dataViews.length) {
    return null;
  }
  const prefixText = filter.meta.negate ? ` ${_i18n.strings.getNotLabel()}` : '';
  const prefix = filter.meta.negate && !filter.meta.disabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, prefixText) : prefixText;
  const filterLabelValue = /*#__PURE__*/_react.default.createElement("span", {
    className: "globalFilterLabel__value",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 28
    }
  }, valueLabel);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
    className: (0, _filter_badge.badgePaddingCss)(euiTheme),
    color: "hollow",
    iconType: readOnly ? 'cross' : undefined,
    iconSide: "right"
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
          white-space: normal;
          overflow-wrap: break-word;
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextBlockTruncate, {
    lines: 10,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, filter.meta.alias && !hideAlias ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
    className: (0, _filter_badge.marginLeftLabelCss)(euiTheme),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 15
    }
  }, prefix, filter.meta.alias, filterLabelStatus && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ": ", filterLabelValue))) : /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }, (0, _esQuery.isCombinedFilter)(filter) && prefix, /*#__PURE__*/_react.default.createElement(_filter_badge_group.FilterBadgeGroup, {
    filters: [filter],
    dataViews: dataViews,
    filterLabelStatus: valueLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 15
    }
  })))));
}