"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApplyFiltersPopoverContent = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _public = require("@kbn/data-plugin/public");
var _filter_badge = require("../../filter_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/actions/apply_filter_action/apply_filter_popover_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ApplyFiltersPopoverContent extends _react2.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getLabel", filter => {
      const valueLabel = (0, _public.getDisplayValueFromFilter)(filter, this.props.indexPatterns);
      const fieldLabel = (0, _public.getFieldDisplayValueFromFilter)(filter, this.props.indexPatterns);
      return /*#__PURE__*/_react2.default.createElement(_filter_badge.FilterContent, {
        filter: filter,
        valueLabel: valueLabel,
        fieldLabel: fieldLabel,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 12
        }
      });
    });
    (0, _defineProperty2.default)(this, "isFilterSelected", i => {
      return this.state.isFilterSelected[i];
    });
    (0, _defineProperty2.default)(this, "toggleFilterSelected", i => {
      const isFilterSelected = [...this.state.isFilterSelected];
      isFilterSelected[i] = !isFilterSelected[i];
      this.setState({
        isFilterSelected
      });
    });
    (0, _defineProperty2.default)(this, "onSubmit", () => {
      const selectedFilters = this.props.filters.filter((filter, i) => this.state.isFilterSelected[i]);
      this.props.onSubmit(selectedFilters);
    });
    this.state = {
      isFilterSelected: props.filters.map(() => true),
      fieldLabel: undefined
    };
  }
  render() {
    if (this.props.filters.length === 0) {
      return '';
    }
    const mappedFilters = (0, _public.mapAndFlattenFilters)(this.props.filters);
    const form = /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 7
      }
    }, mappedFilters.map((filter, i) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
      key: i,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiCheckbox, {
      id: `filterCheckbox-${i}`,
      label: this.getLabel(filter),
      checked: this.isFilterSelected(i),
      onChange: () => this.toggleFilterSelected(i),
      css: (0, _react.css)`
                word-break: break-word;
              `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    }))));
    return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeaderTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.filter.applyFilters.popupHeader",
      defaultMessage: "Select filters to apply",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 9
      }
    }, form), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this.props.onCancel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.filter.applyFiltersPopup.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      onClick: this.onSubmit,
      "data-test-subj": "applyFiltersPopoverButton",
      fill: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.filter.applyFiltersPopup.saveButtonLabel",
      defaultMessage: "Apply",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 13
      }
    }))));
  }
}
exports.ApplyFiltersPopoverContent = ApplyFiltersPopoverContent;
(0, _defineProperty2.default)(ApplyFiltersPopoverContent, "defaultProps", {
  filters: []
});